/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cache;

import java.lang.ref.Reference;
import java.util.LinkedHashMap;
import java.util.Map;
import net.spy.cache.CacheListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private int maxSize = 0;

    public LRUCache(int size) {
        super(size, 0.75f, true);
        this.maxSize = size;
    }

    @Override
    public V get(Object o) {
        Object rv = super.get(o);
        if (rv instanceof Reference) {
            rv = ((Reference)rv).get();
        }
        return rv;
    }

    @Override
    public V put(K key, V val) {
        if (val instanceof CacheListener) {
            CacheListener cl = (CacheListener)val;
            cl.cachedEvent(key);
        }
        return super.put(key, val);
    }

    private void sendRemovedEvent(Object key, Object value) {
        if (value != null && value instanceof CacheListener) {
            CacheListener cl = (CacheListener)value;
            cl.uncachedEvent(key);
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> e) {
        boolean shouldRemove = false;
        boolean bl = shouldRemove = this.size() > this.maxSize;
        if (shouldRemove) {
            this.sendRemovedEvent(e.getKey(), e.getValue());
        }
        return shouldRemove;
    }
}

