/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.SpyObject;
import net.spy.concurrent.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper<F, T>
extends SpyObject {
    private ExecutorService executor = null;

    public Mapper() {
        this(new DummyExecutor());
    }

    public Mapper(ExecutorService x) {
        this.executor = x;
    }

    public List<T> transform(Transformer<F, T> trans, Collection<? extends F> in) throws InterruptedException {
        ArrayList rv = new ArrayList(in.size());
        List fs = this.executor.invokeAll(new TransformingCollection<F, T>(trans, in));
        for (Future f : fs) {
            try {
                rv.add(f.get());
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Error processing get", e);
            }
        }
        return rv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformingCollection<F, T>
    extends AbstractCollection<Callable<T>> {
        Collection<? extends F> backingCollection = null;
        Transformer<F, T> transformer = null;

        public TransformingCollection(Transformer<F, T> trans, Collection<? extends F> in) {
            this.transformer = trans;
            this.backingCollection = in;
        }

        @Override
        public Iterator<Callable<T>> iterator() {
            return new Titerator();
        }

        @Override
        public int size() {
            return this.backingCollection.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Titerator
        implements Iterator<Callable<T>> {
            Iterator<? extends F> backingIterator;

            Titerator() {
                this.backingIterator = TransformingCollection.this.backingCollection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backingIterator.hasNext();
            }

            @Override
            public Callable<T> next() {
                return new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return TransformingCollection.this.transformer.transform(Titerator.this.backingIterator.next());
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DummyExecutor
    extends AbstractExecutorService {
        private boolean isShutdown = false;

        DummyExecutor() {
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public boolean isShutdown() {
            return this.isShutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown;
        }

        @Override
        public void shutdown() {
            this.isShutdown = true;
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public void execute(Runnable command) {
            assert (!this.isShutdown) : "I'm already shutdown";
            command.run();
        }
    }
}

