/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.SpyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizationObject<T>
extends SpyObject {
    private T theObject = null;

    public SynchronizationObject(T o) {
        this.theObject = o;
    }

    public synchronized T get() {
        return this.theObject;
    }

    public synchronized T set(T o) {
        T rv = this.theObject;
        this.theObject = o;
        this.notifyAll();
        return rv;
    }

    public String toString() {
        return "{SynchronizationObject obj=" + this.get() + "}";
    }

    public synchronized void waitUntilTrue(Predicate<T> p, long timeout, TimeUnit timeunit) throws InterruptedException, TimeoutException {
        assert (p != null) : "Null predicate";
        assert (timeout >= 0L) : "Invalid timeout";
        long now = System.currentTimeMillis();
        long theEnd = now + timeunit.toMillis(timeout);
        if (theEnd < 0L) {
            theEnd = Long.MAX_VALUE;
        }
        while (!p.evaluate(this.theObject)) {
            if (now >= theEnd) {
                throw new TimeoutException();
            }
            this.wait(timeunit.toMillis(theEnd - now));
            now = System.currentTimeMillis();
        }
    }

    public void waitUntilNotNull(long timeout, TimeUnit timeunit) throws InterruptedException, TimeoutException {
        this.waitUntilTrue(new Predicate<T>(){

            @Override
            public boolean evaluate(T o) {
                return o != null;
            }
        }, timeout, timeunit);
    }

    public void waitUntilEquals(final T val, long timeout, TimeUnit timeunit) throws InterruptedException, TimeoutException {
        this.waitUntilTrue(new Predicate<T>(){

            @Override
            public boolean evaluate(T o) {
                return val == null ? o == null : val.equals(o);
            }
        }, timeout, timeunit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Predicate<T> {
        public boolean evaluate(T var1);
    }
}

