/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.concurrent.ThreadPoolObserver;
import net.spy.concurrent.WorkerThread;
import net.spy.log.Logger;
import net.spy.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPool
extends ThreadPoolExecutor {
    private ThreadPoolObserver monitor = null;
    private static final int DEFAULT_LIST_LIMIT = 8192;
    private static final int DEFAULT_NUM_THREADS = 5;
    private static final int WAIT_TIMEOUT = 5000;
    private Map<Runnable, WorkerThread> currentWorkers = new ConcurrentHashMap<Runnable, WorkerThread>();
    private transient Logger logger = null;

    public ThreadPool(String name, int n, int max, int prio, BlockingQueue<Runnable> q) {
        super(n, max, 1L, TimeUnit.SECONDS, q, new MyThreadFactory(name, prio));
        this.setPriority(prio);
        this.monitor = new ThreadPoolObserver();
    }

    public ThreadPool(String name, int n, int max, int prio, int size) {
        this(name, n, max, prio, new ArrayBlockingQueue<Runnable>(size, true));
    }

    public ThreadPool(String name, int n, int max, int prio) {
        this(name, n, max, prio, 8192);
    }

    public ThreadPool(String name, int n, int max) {
        this(name, n, max, 5);
    }

    public ThreadPool(String name, int n) {
        this(name, n, n);
    }

    public ThreadPool(String name) {
        this(name, 5, 5);
    }

    public synchronized void start() {
        int threads = this.prestartAllCoreThreads();
        this.getLogger().info("Started %d of %d threads", threads, this.getCorePoolSize());
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public int getIdleThreadCount() {
        return this.getPoolSize() - this.getActiveCount();
    }

    @Override
    public String toString() {
        return super.toString() + " - " + this.getQueue().size() + " of a maximum " + 8192 + " tasks queud";
    }

    public int getMinTotalThreads() {
        return this.getCorePoolSize();
    }

    public int getPriority() {
        MyThreadFactory t = (MyThreadFactory)this.getThreadFactory();
        return t.priority;
    }

    public void setPriority(int p) {
        MyThreadFactory t = (MyThreadFactory)this.getThreadFactory();
        t.setPriority(p);
    }

    public ThreadPoolObserver getMonitor() {
        return this.monitor;
    }

    public void setMonitor(ThreadPoolObserver m) {
        this.monitor = m;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        assert (t instanceof WorkerThread) : "Thread is not a WorkerThread";
        WorkerThread wt = (WorkerThread)t;
        wt.setRunning(r);
        this.currentWorkers.put(r, wt);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.monitor.completedJob(r);
        WorkerThread wt = this.currentWorkers.get(r);
        assert (wt != null) : "Lost worker for " + r;
        wt.setRunning(null);
        this.currentWorkers.remove(r);
    }

    public void addTask(Runnable r) {
        this.execute(r);
    }

    public boolean addTask(Runnable r, long timeout) {
        boolean wasDone = false;
        Future<Boolean> f = this.submit(r, true);
        try {
            f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.getLogger().debug((Object)"Interrupted while waiting for task", e);
            f.cancel(true);
        }
        catch (ExecutionException e) {
            this.getLogger().debug((Object)"Task execution threw an exception", e);
            wasDone = true;
        }
        catch (TimeoutException e) {
            this.getLogger().debug((Object)"Timed out while waiting for execution", e);
            f.cancel(true);
        }
        return wasDone;
    }

    public void waitForCompletion() throws InterruptedException {
        this.waitForTaskCount(0);
        this.shutdown();
        this.awaitTermination(86400L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTaskCount(int num) throws InterruptedException {
        ThreadPoolObserver threadPoolObserver = this.monitor;
        synchronized (threadPoolObserver) {
            while (this.getQueue().size() > num) {
                this.monitor.wait(5000L);
            }
        }
    }

    static final class MyThreadFactory
    implements ThreadFactory {
        private String name = null;
        int priority = 5;

        MyThreadFactory(String nm, int prio) {
            this.name = nm;
            this.setPriority(prio);
        }

        public void setPriority(int to) {
            if (to < 1 || to > 10) {
                throw new IllegalArgumentException(to + " is an invalid priority.");
            }
        }

        public Thread newThread(Runnable r) {
            WorkerThread t = new WorkerThread(r, this.name + " worker");
            t.setPriority(this.priority);
            return t;
        }
    }
}

