/*
 * Decompiled with CFR 0.152.
 */
package net.spy.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import net.spy.concurrent.WorkerThread;

public class TrackingScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private Map<Runnable, WorkerThread> currentWorkers = new ConcurrentHashMap<Runnable, WorkerThread>();

    public TrackingScheduledExecutor(int maxThreads, RejectedExecutionHandler reject, final ThreadGroup tg, final String name) {
        super(maxThreads, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                WorkerThread rv = new WorkerThread(tg, r, name);
                return rv;
            }
        }, reject);
    }

    public TrackingScheduledExecutor(int maxThreads, final ThreadGroup tg, final String name) {
        super(maxThreads, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                WorkerThread rv = new WorkerThread(tg, r, name);
                return rv;
            }
        });
    }

    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        assert (t instanceof WorkerThread) : "Thread is not a WorkerThread";
        WorkerThread wt = (WorkerThread)t;
        wt.setRunning(r);
        this.currentWorkers.put(r, wt);
    }

    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        WorkerThread wt = this.currentWorkers.get(r);
        assert (wt != null) : "Lost worker for " + r;
        wt.setRunning(null);
        this.currentWorkers.remove(r);
    }
}

