/*
 * Decompiled with CFR 0.152.
 */
package net.spy.cron;

import java.util.Date;
import net.spy.SpyObject;
import net.spy.cron.TimeIncrement;

public abstract class Job
extends SpyObject
implements Runnable {
    private Date nextStart = null;
    private TimeIncrement increment = null;
    private boolean isrunning = false;
    private String name = null;

    public Job(String nm, Date startDate) {
        this(nm, startDate, null);
    }

    public Job(String nm, Date startDate, TimeIncrement ti) {
        this.nextStart = startDate;
        this.increment = ti;
        this.setName(nm);
    }

    public String toString() {
        return "Job:" + this.getName();
    }

    public void setName(String to) {
        this.name = to;
    }

    public String getName() {
        return this.name;
    }

    public synchronized Date getStartTime() {
        return this.nextStart;
    }

    public void setStartTime(Date to) {
        this.nextStart = to;
    }

    public boolean isReady() {
        boolean rv = false;
        if (this.nextStart == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.nextStart.getTime() <= now && !this.isAlive()) {
            rv = true;
        }
        return rv;
    }

    public final void run() {
        this.markStarted();
        this.runJob();
        this.markFinished();
    }

    protected abstract void runJob();

    public boolean isTrash() {
        return this.nextStart == null;
    }

    protected TimeIncrement getTimeIncrement() {
        return this.increment;
    }

    protected void markStarted() {
        this.isrunning = true;
    }

    public final synchronized void findNextRun() {
        if (this.increment == null) {
            this.nextStart = null;
            this.getLogger().debug("I have no time increment, not rescheduling");
        } else {
            Date now = new Date();
            while (this.nextStart.before(now)) {
                this.nextStart = this.increment.nextDate(this.nextStart);
            }
            this.getLogger().debug("Rescheduled %s for %s", this, this.nextStart);
        }
    }

    protected void stopRunning() {
        this.nextStart = null;
        this.increment = null;
    }

    public boolean isAlive() {
        return this.isrunning;
    }

    protected void markFinished() {
        this.isrunning = false;
    }
}

