/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import net.spy.cache.SimpleCache;
import net.spy.db.CachedResultSet;
import net.spy.db.DBNull;
import net.spy.db.GenericPreparedStatementStub;
import net.spy.db.SpyDB;
import net.spy.db.TypeNames;

public class CachePreparedStatementStub
extends GenericPreparedStatementStub {
    SpyDB db = null;
    private long cacheTime = 3600000L;
    private int timeout = 0;
    private int maxRows = 0;

    public CachePreparedStatementStub(SpyDB d, String query, long cTime) {
        super(query);
        this.db = d;
        this.cacheTime = cTime;
    }

    public int hashCode() {
        int hc = 0;
        hc += this.getQuery().hashCode();
        StringBuilder sb = new StringBuilder(256);
        for (int i = 0; i < this.getArgs().length; ++i) {
            sb.append(this.getArgs()[i]);
            sb.append('\u0000');
        }
        return hc += sb.toString().hashCode();
    }

    public boolean equals(Object o) {
        boolean rv = false;
        int otherHc = o.hashCode();
        if (otherHc == this.hashCode() && o instanceof CachePreparedStatementStub) {
            CachePreparedStatementStub cpss = (CachePreparedStatementStub)o;
            String oQuery = cpss.getQuery();
            Object[] otherArgs = cpss.getArgs();
            if (oQuery != null && oQuery.equals(this.getQuery())) {
                rv = Arrays.equals(this.getArgs(), otherArgs);
            }
        }
        return rv;
    }

    public ResultSet executeQuery() throws SQLException {
        int hc = this.hashCode();
        String key = "dbcache_prepared_" + hc;
        SimpleCache cache = SimpleCache.getInstance();
        CachedResultSet crs = (CachedResultSet)cache.get(key);
        if (crs == null) {
            crs = this.realExecuteQuery();
            cache.store(key, crs, this.cacheTime * 1000L);
        }
        ResultSet crsret = (ResultSet)((Object)crs.newCopy());
        return crsret;
    }

    public void setQueryTimeout(int to) throws SQLException {
        if (to < 0) {
            throw new SQLException("Invalid value for query timeout:  " + to);
        }
        this.timeout = to;
    }

    public void setMaxRows(int to) throws SQLException {
        if (to < 0) {
            throw new SQLException("Invalid value for max rows:  " + to);
        }
        this.maxRows = to;
    }

    private CachedResultSet realExecuteQuery() throws SQLException {
        PreparedStatement pst = this.db.prepareStatement(this.getQuery());
        pst.setQueryTimeout(this.timeout);
        pst.setMaxRows(this.maxRows);
        Object[] args = this.getArgs();
        for (int i = 0; i < args.length; ++i) {
            try {
                switch (this.getTypes()[i]) {
                    case -7: {
                        pst.setBoolean(i + 1, (Boolean)args[i]);
                        break;
                    }
                    case 91: {
                        pst.setDate(i + 1, (Date)args[i]);
                        break;
                    }
                    case 8: {
                        pst.setDouble(i + 1, (Double)args[i]);
                        break;
                    }
                    case 6: {
                        pst.setFloat(i + 1, ((Float)args[i]).floatValue());
                        break;
                    }
                    case 4: {
                        pst.setInt(i + 1, (Integer)args[i]);
                        break;
                    }
                    case -5: {
                        pst.setLong(i + 1, (Long)args[i]);
                        break;
                    }
                    case -6: {
                        pst.setShort(i + 1, (short)((Integer)args[i]).intValue());
                        break;
                    }
                    case 0: {
                        pst.setNull(i + 1, ((DBNull)args[i]).getType());
                        break;
                    }
                    case 1111: {
                        pst.setObject(i + 1, args[i]);
                        break;
                    }
                    case 12: {
                        pst.setString(i + 1, (String)args[i]);
                        break;
                    }
                    case 92: {
                        pst.setTime(i + 1, (Time)args[i]);
                        break;
                    }
                    case 93: {
                        pst.setTimestamp(i + 1, (Timestamp)args[i]);
                        break;
                    }
                    case 3: {
                        pst.setBigDecimal(i + 1, (BigDecimal)args[i]);
                        break;
                    }
                    default: {
                        throw new SQLException("Whoops, type " + this.getTypes()[i] + " (" + TypeNames.getTypeName(this.getTypes()[i]) + ") seems to have been overlooked.");
                    }
                }
                continue;
            }
            catch (NullPointerException ex) {
                this.getLogger().error("error with %s in type %s at param position %d", args[i], this.getTypes()[i], i);
                throw ex;
            }
        }
        return new CachedResultSet(pst.executeQuery());
    }

    public int executeUpdate() throws SQLException {
        throw new SQLException("Illegal?  This operation makes no sense!");
    }

    public void close() throws SQLException {
        super.close();
        this.db = null;
    }
}

