/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import net.spy.db.DBSP;
import net.spy.db.QuerySelector;
import net.spy.db.QuerySelectorFactory;
import net.spy.util.SpyConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBSQL
extends DBSP {
    private Map<String, String> registeredQueries = null;

    public DBSQL(SpyConfig conf) throws SQLException {
        super(conf);
    }

    public DBSQL(Connection conn) throws SQLException {
        super(conn);
    }

    protected void setRegisteredQueryMap(Map<String, String> to) {
        this.registeredQueries = to;
    }

    public Map<String, String> getRegisteredQueries() {
        return Collections.unmodifiableMap(this.registeredQueries);
    }

    @Override
    protected void prepare() throws SQLException {
        if (this.getPreparedStatement() == null && this.registeredQueries != null) {
            this.selectQuery();
        }
        this.checkArgs();
        this.applyArgs(this.getArguments());
    }

    protected void generateCursorName() throws SQLException {
        String className;
        StringBuilder sb = new StringBuilder();
        int totalSize = 32;
        int idhc = System.identityHashCode(this);
        String idhcs = Integer.toHexString(idhc);
        totalSize -= idhcs.length();
        String shortClassName = className = this.getClass().getName();
        StringTokenizer st = new StringTokenizer(className, ".");
        while (st.hasMoreTokens()) {
            shortClassName = st.nextToken();
        }
        if (shortClassName.length() < totalSize) {
            sb.append(shortClassName);
        } else {
            sb.append(shortClassName.substring(shortClassName.length() - totalSize));
        }
        sb.append(idhcs);
        this.setCursorName(sb.toString());
    }

    private void selectQuery() throws SQLException {
        QuerySelector qs = QuerySelectorFactory.getQuerySelector();
        String query = qs.getQuery(this.getConn(), this.registeredQueries);
        if (query == null) {
            throw new SQLException("Could not find query for " + this.getClass().getName());
        }
        this.setQuery(query);
    }
}

