/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.spy.SpyObject;
import net.spy.db.QuerySelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseMetaDataQuerySelector
extends SpyObject
implements QuerySelector {
    private SortedMap<String, String> nameMap = new TreeMap<String, String>();

    public DatabaseMetaDataQuerySelector() {
        this.initNameMap();
    }

    protected void initNameMap() {
        this.registerNameMapping("PostgreSQL", "pgsql");
        this.registerNameMapping("Oracle", "oracle");
        this.registerNameMapping("Microsoft SQL Server", "mssql");
        this.registerNameMapping("MySQL", "mysql");
        this.registerNameMapping("DB2 UDB for AS/400", "db2");
        this.registerNameMapping("Informix Dynamic Server", "informix");
        this.registerNameMapping("INFORMIX-OnLine", "informix");
    }

    protected void registerNameMapping(String prefix, String name) {
        this.nameMap.put(prefix, name);
    }

    @Override
    public String getQuery(Connection conn, Map<String, String> queryMap) throws SQLException {
        return this.getQuery(conn.getMetaData().getDatabaseProductName(), queryMap);
    }

    protected String getQuery(String name, Map<String, String> queryMap) {
        String rv = null;
        rv = queryMap.get(name);
        if (rv == null) {
            String tmp = (String)this.nameMap.get(name);
            if (tmp == null) {
                this.getLogger().debug("Unknown driver:  %s", name);
                tmp = "-default-";
            }
            if ((rv = queryMap.get(tmp)) == null) {
                tmp = "-default-";
                rv = queryMap.get(tmp);
            }
        }
        return rv;
    }
}

