/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.spy.db.GenericResultSetStub;
import net.spy.db.TypeNames;
import net.spy.util.CloseUtil;

public class FileResultSetStub
extends GenericResultSetStub {
    public FileResultSetStub(URL f, int maxResults) throws SQLException {
        try {
            this.initFromURL(f, maxResults);
        }
        catch (IOException e) {
            SQLException toThrow = new SQLException("Could not initialize results from " + f);
            toThrow.initCause(e);
            throw toThrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFromURL(URL u, int maxResults) throws SQLException, IOException {
        InputStream is = null;
        try {
            is = u.openStream();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
            MyMetaData mmd = new MyMetaData(lnr.readLine());
            this.setMetaData(mmd);
            ArrayList<Object[]> results = new ArrayList<Object[]>();
            String tmp = lnr.readLine();
            while (tmp != null && results.size() < maxResults) {
                Object[] result = mmd.parseLine(tmp);
                results.add(result);
                tmp = lnr.readLine();
            }
            this.setResults(results);
        }
        finally {
            CloseUtil.close(is);
        }
    }

    static final class MyMetaData
    implements ResultSetMetaData {
        private String[] names = null;
        private int[] types = null;

        public MyMetaData(String line) throws SQLException {
            StringTokenizer st = new StringTokenizer(line, "\t");
            this.names = new String[st.countTokens()];
            this.types = new int[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String desc = st.nextToken();
                StringTokenizer parts = new StringTokenizer(desc, ":");
                this.names[i] = parts.nextToken();
                this.types[i] = this.lookupType(parts.nextToken());
                ++i;
            }
        }

        private int lookupType(String typeName) throws SQLException {
            int rv = 0;
            try {
                Field f = Types.class.getDeclaredField(typeName);
                rv = (Integer)f.get(null);
            }
            catch (Exception e) {
                SQLException toThrow = new SQLException("Cannot look up type " + typeName);
                toThrow.initCause(e);
                throw toThrow;
            }
            return rv;
        }

        public Object[] parseLine(String line) throws SQLException {
            ParserFactory pf = ParserFactory.getInstance();
            StringTokenizer st = new StringTokenizer(line, "\t");
            Object[] rv = new Object[this.names.length];
            int i = 0;
            while (st.hasMoreTokens()) {
                String toParse = st.nextToken();
                try {
                    rv[i] = pf.getParser(this.types[i]).parseString(toParse);
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    SQLException toThrow = new SQLException("Couldn't parse " + toParse + " as " + TypeNames.getTypeName(this.types[i]));
                    toThrow.initCause(e);
                    throw toThrow;
                }
                ++i;
            }
            return rv;
        }

        public int getColumnCount() throws SQLException {
            return this.names.length;
        }

        public boolean isAutoIncrement(int col) throws SQLException {
            return false;
        }

        public boolean isCaseSensitive(int col) throws SQLException {
            return true;
        }

        public boolean isSearchable(int col) throws SQLException {
            return false;
        }

        public boolean isCurrency(int col) throws SQLException {
            return false;
        }

        public int isNullable(int col) throws SQLException {
            return 0;
        }

        public boolean isSigned(int col) throws SQLException {
            return false;
        }

        public int getColumnDisplaySize(int col) throws SQLException {
            return 20;
        }

        public String getColumnLabel(int col) throws SQLException {
            return this.names[col - 1];
        }

        public String getColumnName(int col) throws SQLException {
            return this.names[col - 1];
        }

        public String getSchemaName(int col) throws SQLException {
            return "testSchema";
        }

        public int getPrecision(int col) throws SQLException {
            return 0;
        }

        public int getScale(int col) throws SQLException {
            return 0;
        }

        public String getTableName(int col) throws SQLException {
            return "testTable";
        }

        public String getCatalogName(int col) throws SQLException {
            return "testCatalog";
        }

        public int getColumnType(int col) throws SQLException {
            return this.types[col - 1];
        }

        public String getColumnTypeName(int col) throws SQLException {
            return TypeNames.getTypeName(this.types[col - 1]);
        }

        public boolean isReadOnly(int col) throws SQLException {
            return true;
        }

        public boolean isWritable(int col) throws SQLException {
            return false;
        }

        public boolean isDefinitelyWritable(int col) throws SQLException {
            return false;
        }

        public String getColumnClassName(int col) throws SQLException {
            return "java.lang.Object";
        }
    }

    static final class ParserFactory {
        private static ParserFactory instance = null;
        private Map<Integer, PreParser> parsers = new HashMap<Integer, PreParser>();

        private ParserFactory() {
            this.parsers.put(new Integer(12), new StringParser());
            this.parsers.put(new Integer(-1), new StringParser());
            this.parsers.put(new Integer(4), new NumberParser());
            this.parsers.put(new Integer(-5), new NumberParser());
            this.parsers.put(new Integer(3), new NumberParser());
            this.parsers.put(new Integer(8), new NumberParser());
            this.parsers.put(new Integer(6), new NumberParser());
            this.parsers.put(new Integer(2), new NumberParser());
            this.parsers.put(new Integer(7), new NumberParser());
            this.parsers.put(new Integer(5), new NumberParser());
            this.parsers.put(new Integer(-6), new NumberParser());
            this.parsers.put(new Integer(93), new TimestampParser());
            this.parsers.put(new Integer(91), new DateParser());
            this.parsers.put(new Integer(92), new TimeParser());
            this.parsers.put(new Integer(-7), new PreParser(){

                public Object subParse(String s) throws Exception {
                    Boolean rv = Boolean.FALSE;
                    try {
                        rv = Integer.parseInt(s) == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    catch (NumberFormatException e) {
                        rv = Boolean.valueOf(s);
                    }
                    return rv;
                }
            });
        }

        public static synchronized ParserFactory getInstance() {
            if (instance == null) {
                instance = new ParserFactory();
            }
            return instance;
        }

        public Parser getParser(int type) throws SQLException {
            Parser rv = this.parsers.get(new Integer(type));
            if (rv == null) {
                throw new SQLException("Don't have a parser for " + TypeNames.getTypeName(type));
            }
            return rv;
        }
    }

    private static final class TimestampParser
    extends MultiDateParser {
        public TimestampParser() {
            super(new String[]{"yyyyMMdd'T'HH:mm:ss.SSS", "yyyyMMdd'T'HH:mm:ss", "yyyyMMdd'T'HHmmss.SSS", "yyyyMMdd'T'HHmmss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "dd/MM/yyyy HH:mm:ss.SSS", "dd/MM/yyyy HH:mm:ss"});
        }

        public Object subParse(String s) throws Exception {
            return new Timestamp(this.parseDate(s));
        }
    }

    private static final class DateParser
    extends MultiDateParser {
        public DateParser() {
            super(new String[]{"yyyyMMdd", "yyyy-MM-dd", "yyyy/MM/dd", "dd/MM/yyyy"});
        }

        public Object subParse(String s) throws Exception {
            return new Date(this.parseDate(s));
        }
    }

    private static final class TimeParser
    extends MultiDateParser {
        public TimeParser() {
            super(new String[]{"HH:mm:ss.SSS", "HH:mm:ss"});
        }

        public Object subParse(String s) throws Exception {
            return new Time(this.parseDate(s));
        }
    }

    static abstract class MultiDateParser
    extends PreParser {
        private SimpleDateFormat[] formats = null;

        public MultiDateParser(String[] formatStrings) {
            this.formats = new SimpleDateFormat[formatStrings.length];
            for (int i = 0; i < formatStrings.length; ++i) {
                this.formats[i] = new SimpleDateFormat(formatStrings[i]);
                this.formats[i].setLenient(false);
            }
        }

        protected long parseDate(String s) {
            long rv = 0L;
            for (int i = 0; rv == 0L && i < this.formats.length; ++i) {
                try {
                    rv = this.formats[i].parse(s).getTime();
                    continue;
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            return rv;
        }
    }

    static final class StringParser
    extends PreParser {
        StringParser() {
        }

        public Object subParse(String s) {
            return s;
        }
    }

    static final class NumberParser
    extends PreParser {
        NumberParser() {
        }

        public Object subParse(String s) throws Exception {
            return new BigDecimal(s);
        }
    }

    static abstract class PreParser
    implements Parser {
        PreParser() {
        }

        public final Object parseString(String s) throws Exception {
            Object rv = null;
            String cleanedUp = this.cleanString(s);
            if (cleanedUp != null) {
                rv = this.subParse(cleanedUp);
            }
            return rv;
        }

        private String cleanString(String s) {
            String rv = null;
            if (!s.equals("\\N")) {
                StringBuilder sb = new StringBuilder(s.length());
                block7: for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    switch (c) {
                        case '\\': {
                            char escaped = s.charAt(++i);
                            switch (escaped) {
                                case 't': {
                                    sb.append('\t');
                                    continue block7;
                                }
                                case 'n': {
                                    sb.append('\n');
                                    continue block7;
                                }
                            }
                            sb.append('\\');
                            continue block7;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                rv = sb.toString();
            }
            return rv;
        }

        protected abstract Object subParse(String var1) throws Exception;
    }

    private static interface Parser {
        public Object parseString(String var1) throws Exception;
    }
}

