/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.spy.SpyObject;
import net.spy.db.ConnectionSource;
import net.spy.util.SpyConfig;

public class JNDIConnectionSource
extends SpyObject
implements ConnectionSource {
    public Connection getConnection(SpyConfig conf) throws SQLException {
        String source = conf.get("dbSource");
        Connection conn = null;
        try {
            Hashtable<Object, Object> env = new Hashtable<Object, Object>(conf);
            InitialContext initial = new InitialContext(env);
            DataSource dsrc = (DataSource)initial.lookup(source);
            conn = dsrc.getConnection();
        }
        catch (NamingException e) {
            this.getLogger().warn((Object)"Error getting connection from JNDI", e);
            throw new SQLException("Error getting connection from JNDI:  " + e);
        }
        return conn;
    }

    public void returnConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.getLogger().warn((Object)"Problem closing connection", e);
        }
    }
}

