/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import net.spy.SpyObject;
import net.spy.db.ConnectionSource;
import net.spy.db.DBInitException;
import net.spy.pool.JDBCPoolFiller;
import net.spy.pool.ObjectPool;
import net.spy.pool.PoolException;
import net.spy.pool.PooledObject;
import net.spy.util.SpyConfig;

public class ObjectPoolConnectionSource
extends SpyObject
implements ConnectionSource {
    private static final int DEFAULT_MAX_CONNS = 5;
    private static ObjectPool pool = null;
    private Map<Connection, PooledObject> objects = new WeakHashMap<Connection, PooledObject>();
    private String poolName = null;

    public Connection getConnection(SpyConfig conf) throws SQLException {
        this.poolName = conf.get("dbPoolName");
        this.initialize(conf);
        Connection conn = null;
        try {
            conn = this.getConn(this.poolName);
        }
        catch (PoolException pe) {
            this.getLogger().warn((Object)"Could not get a DB connection", pe);
            throw new DBInitException("Could not get a DB connection:  " + pe);
        }
        return conn;
    }

    private Connection getConn(String name) throws SQLException, PoolException {
        Connection rv = null;
        PooledObject object = pool.getObject(name);
        rv = (Connection)object.getObject();
        this.objects.put(rv, object);
        return rv;
    }

    public void returnConnection(Connection conn) {
        PooledObject object = this.objects.get(conn);
        if (object == null) {
            throw new NullPointerException("Object is null, already returned?");
        }
        object.checkIn();
        this.objects.remove(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(SpyConfig gConf) throws SQLException {
        Class<ObjectPoolConnectionSource> clazz = ObjectPoolConnectionSource.class;
        synchronized (ObjectPoolConnectionSource.class) {
            SpyConfig conf = null;
            if (pool == null) {
                conf = (SpyConfig)gConf.clone();
                pool = new ObjectPool(conf);
            }
            if (!pool.hasPool(this.poolName)) {
                if (conf == null) {
                    conf = (SpyConfig)gConf.clone();
                }
                try {
                    this.createPool(conf);
                }
                catch (PoolException pe) {
                    this.getLogger().error((Object)"Problem initializing pool", pe);
                    throw new SQLException("Error initializing pool:  " + pe);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void createPool(SpyConfig conf) throws SQLException, PoolException {
        SpyConfig normConf = this.getNormalizedConfig(this.poolName, conf);
        JDBCPoolFiller pf = new JDBCPoolFiller(this.poolName, normConf);
        pool.createPool(this.poolName, pf);
    }

    private SpyConfig getNormalizedConfig(String name, SpyConfig conf) throws SQLException {
        SpyConfig rv = new SpyConfig();
        String prefix = "";
        if (name != null) {
            prefix = name + ".";
        }
        int minConns = conf.getInt("dbMinConns", 1);
        rv.put(prefix + "min", "" + minConns);
        int startConns = conf.getInt("dbStartCons", minConns);
        rv.put(prefix + "start", "" + startConns);
        int yellowLine = conf.getInt("dbYellowLine", -1);
        if (yellowLine > 0) {
            rv.put(prefix + "yellow_line", "" + yellowLine);
        }
        int maxConns = conf.getInt("dbMaxConns", 5);
        rv.put(prefix + "max", "" + maxConns);
        String tmp = conf.get("dbMaxLifeTime");
        if (tmp == null) {
            tmp = "86400";
        }
        rv.put(prefix + "max_age", tmp);
        tmp = conf.get("dbPingOnCheckout", "true");
        rv.put(prefix + "pingOnCheckout", tmp);
        tmp = conf.get("dbDriverName");
        if (tmp == null) {
            throw new SQLException("dbDriverName not given, invalid configuration.");
        }
        rv.put(prefix + "dbDriverName", tmp);
        tmp = conf.get("dbSource");
        if (tmp == null) {
            throw new SQLException("dbSource not given, invalid configuration.");
        }
        rv.put(prefix + "dbSource", tmp);
        tmp = conf.get("dbUser");
        if (tmp == null) {
            throw new SQLException("dbUser not given, invalid configuration.");
        }
        rv.put(prefix + "dbUser", tmp);
        tmp = conf.get("dbPass");
        if (tmp == null) {
            throw new SQLException("dbPass not given, invalid configuration.");
        }
        rv.put(prefix + "dbPass", tmp);
        Enumeration<?> e = conf.propertyNames();
        while (e.hasMoreElements()) {
            String pname = (String)e.nextElement();
            if (!pname.startsWith("dboption.")) continue;
            String ovalue = conf.get(pname);
            rv.put(prefix + pname, ovalue);
        }
        return rv;
    }
}

