/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import net.spy.SpyObject;
import net.spy.db.DatabaseMetaDataQuerySelector;
import net.spy.db.QuerySelector;
import net.spy.log.Logger;
import net.spy.log.LoggerFactory;

public class QuerySelectorFactory
extends SpyObject {
    private static QuerySelector qs = null;
    private static final String PROPERTY_NAME = "net.spy.db.QuerySelector";
    private static final String DEFAULT_SELECTOR = "net.spy.db.DatabaseMetaDataQuerySelector";

    public static QuerySelector getQuerySelector() {
        QuerySelectorFactory.initQuerySelector();
        return qs;
    }

    private static synchronized void initQuerySelector() {
        if (qs == null) {
            String selectorClassName = System.getProperty(PROPERTY_NAME, DEFAULT_SELECTOR);
            try {
                Class<?> c = Class.forName(selectorClassName);
                qs = (QuerySelector)c.newInstance();
            }
            catch (Exception e) {
                Logger l = LoggerFactory.getLogger(QuerySelectorFactory.class);
                l.warn("Couldn't make a %s, using %s", selectorClassName, DEFAULT_SELECTOR, e);
                qs = new DatabaseMetaDataQuerySelector();
            }
        }
    }
}

