/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.spy.SpyObject;

public class SQLRunner
extends SpyObject {
    private Connection connection = null;
    private int timeout = 0;

    public SQLRunner(Connection conn) {
        this.connection = conn;
    }

    public void setTimeout(int to) {
        this.timeout = to;
    }

    public void runScript(InputStream is) throws SQLException, IOException {
        this.runScript(is, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(InputStream is, boolean autocommit, boolean errok) throws SQLException, IOException {
        LineNumberReader lr = new LineNumberReader(new InputStreamReader(is));
        boolean successful = false;
        boolean origAutoCommit = true;
        try {
            origAutoCommit = this.connection.getAutoCommit();
            if (origAutoCommit != autocommit) {
                this.connection.setAutoCommit(autocommit);
            }
            this.executeScript(lr, errok);
            if (!autocommit) {
                this.connection.commit();
            }
            successful = true;
        }
        finally {
            lr.close();
            if (this.connection != null) {
                if (!successful) {
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException e) {
                        this.getLogger().warn((Object)"Error rolling back", e);
                    }
                }
                if (origAutoCommit != autocommit) {
                    try {
                        this.connection.setAutoCommit(origAutoCommit);
                    }
                    catch (SQLException e) {
                        this.getLogger().warn("Error resetting autocommit");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(LineNumberReader lr, boolean errok) throws SQLException, IOException {
        String curline = null;
        StringBuilder query = new StringBuilder(1024);
        while ((curline = lr.readLine()) != null) {
            if ((curline = curline.trim()).equals(";")) {
                long starttime;
                int affected;
                Statement st;
                block9: {
                    st = this.connection.createStatement();
                    st.setQueryTimeout(this.timeout);
                    affected = 0;
                    starttime = System.currentTimeMillis();
                    try {
                        affected = st.executeUpdate(query.toString());
                    }
                    catch (SQLException e) {
                        if (errok) {
                            this.getLogger().warn("Ignoring problem executing %s", query, e);
                            break block9;
                        }
                        throw e;
                    }
                    finally {
                        st.close();
                    }
                }
                long stoptime = System.currentTimeMillis();
                st = null;
                this.getLogger().info("Affected %d %s in %dms", affected, affected == 1 ? "row" : "row", stoptime - starttime);
                query.delete(0, query.length() + 1);
                continue;
            }
            if (curline.startsWith("--")) {
                this.getLogger().info(lr.getLineNumber() + ":  " + curline);
                continue;
            }
            if (curline.length() <= 0) continue;
            query.append(curline);
            query.append("\n");
        }
    }
}

