/*
 * Decompiled with CFR 0.152.
 */
package net.spy.db;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.spy.cache.SimpleCache;
import net.spy.db.CachePreparedStatement;
import net.spy.db.CachedResultSet;
import net.spy.db.SpyDB;
import net.spy.util.SpyConfig;

public class SpyCacheDB
extends SpyDB {
    public SpyCacheDB(SpyConfig conf) throws SQLException {
        super(conf);
    }

    public SpyCacheDB(Connection conn) {
        super(conn);
    }

    public ResultSet executeQuery(String query, long lifetime) throws SQLException {
        String key;
        SimpleCache cache = SimpleCache.getInstance();
        CachedResultSet crs = (CachedResultSet)cache.get(key = "cachedb_" + query);
        if (crs == null) {
            ResultSet rs = this.executeQuery(query);
            crs = new CachedResultSet(rs);
            cache.store(key, new SoftReference<CachedResultSet>(crs), lifetime * 1000L);
        }
        ResultSet crsret = (ResultSet)((Object)crs.newCopy());
        return crsret;
    }

    public PreparedStatement prepareStatement(String query, long lifetime) throws SQLException {
        return new CachePreparedStatement(this, query, lifetime);
    }
}

