/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class StoreOperationImpl
extends OperationImpl
implements StoreOperation {
    private static final int OVERHEAD = 32;
    private static final OperationStatus STORED = new OperationStatus(true, "STORED");
    private final StoreType type;
    private final String key;
    private final int flags;
    private final int exp;
    private final byte[] data;

    public StoreOperationImpl(StoreType t, String k, int f, int e, byte[] d, OperationCallback cb) {
        super(cb);
        this.type = t;
        this.key = k;
        this.flags = f;
        this.exp = e;
        this.data = d;
    }

    public void handleLine(String line) {
        assert (this.getState() == OperationState.READING) : "Read ``" + line + "'' when in " + (Object)((Object)this.getState()) + " state";
        this.getCallback().receivedStatus(this.matchStatus(line, STORED));
        this.transitionState(OperationState.COMPLETE);
    }

    public void initialize() {
        ByteBuffer bb = ByteBuffer.allocate(this.data.length + KeyUtil.getKeyBytes(this.key).length + 32);
        this.setArguments(bb, this.type.name(), this.key, this.flags, this.exp, this.data.length);
        assert (bb.remaining() >= this.data.length + 2) : "Not enough room in buffer, need another " + (2 + this.data.length - bb.remaining());
        bb.put(this.data);
        bb.put(CRLF);
        bb.flip();
        this.setBuffer(bb);
    }

    protected void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }
}

