/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import net.spy.memcached.ops.MutatatorOperation;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.binary.OperationImpl;

class MutatorOperationImpl
extends OperationImpl
implements MutatatorOperation {
    private static final int CMD_INCR = 5;
    private static final int CMD_DECR = 6;
    private final String key;
    private final long by;
    private final int exp;
    private final long def;

    public MutatorOperationImpl(Mutator m, String k, long b, long d, int e, OperationCallback cb) {
        super(m == Mutator.incr ? 5 : 6, MutatorOperationImpl.generateOpaque(), cb);
        assert (d >= 0L) : "Default value is below zero";
        this.key = k;
        this.by = b;
        this.exp = e;
        this.def = d;
    }

    public void initialize() {
        byte[] defBytes = new byte[]{(byte)(this.def >> 56 & 0xFFL), (byte)(this.def >> 48 & 0xFFL), (byte)(this.def >> 40 & 0xFFL), (byte)(this.def >> 32 & 0xFFL), (byte)(this.def >> 24 & 0xFFL), (byte)(this.def >> 16 & 0xFFL), (byte)(this.def >> 8 & 0xFFL), (byte)(this.def & 0xFFL)};
        this.prepareBuffer(this.key, 0L, EMPTY_BYTES, this.by, defBytes, this.exp);
    }

    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        return errCode == 1 ? NOT_FOUND_STATUS : null;
    }

    protected void decodePayload(byte[] pl) {
        this.getCallback().receivedStatus(new OperationStatus(true, String.valueOf(MutatorOperationImpl.decodeLong(pl, 0))));
    }
}

