/*
 * Decompiled with CFR 0.152.
 */
package net.spy.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import net.spy.SpyObject;
import net.spy.util.SpyUtil;

public class SNPP
extends SpyObject {
    private static final int STATUS_TYPE_LENGTH = 1;
    private static final int STATUS_LENGTH = 3;
    public static final int SNPP_PORT = 444;
    public static final int MULTILINE_HELP = 214;
    public static final int SINGLELINE_HELP = 218;
    public static final int QUIT_ACK = 221;
    public static final int OK = 250;
    public static final int FATAL_ERROR = 421;
    public static final int COMMAND_NOT_IMPLEMENTED = 500;
    public static final int DUPLICATE_COMMAND_ENTRY = 503;
    public static final int ADMIN_FAILURE = 550;
    public static final int SYSTEM_FAILURE = 554;
    public static final int MAX_ENTRIES_EXCEEDED = 552;
    public static final int DATA_OK = 354;
    public static final int MSG_AWAITING_ACK = 860;
    public static final int MSG_AWAITING_REPLY = 861;
    public static final int MSG_DELIVERED = 880;
    public static final int RESPONSE = 889;
    public static final int MSG_QUEUED = 960;
    public static final int MTYPE_SUCCESS = 2;
    public static final int MTYPE_DATA_SUCCESS = 3;
    public static final int MTYPE_PERM_FAILURE = 4;
    public static final int MTYPE_TEMP_FAILURE = 5;
    public static final int MTYPE_UNSUCCESSFUL_2WAY = 7;
    public static final int MTYPE_SUCCESS_2WAY = 8;
    public static final int MTYPE_SUCCESS_QUEUED = 9;
    private Socket socket = null;
    private InputStream in = null;
    private OutputStream out = null;
    private BufferedReader din = null;
    private PrintWriter prout = null;
    private boolean goesBothWays = false;
    private String msgTag = null;
    private String currentLine = null;
    private String currentMessage = null;
    private int currentStatus = -1;
    private int currentStatusType = -1;

    public SNPP(String host, int port, int timeout) throws IOException, UnknownHostException {
        this.socket = new Socket(host, port);
        if (timeout > 0) {
            this.socket.setSoTimeout(timeout);
        }
        this.in = this.socket.getInputStream();
        this.din = new BufferedReader(new InputStreamReader(this.in));
        this.out = this.socket.getOutputStream();
        this.prout = new PrintWriter(this.out);
        this.getaline();
    }

    public SNPP(String host, int port) throws IOException, UnknownHostException {
        this(host, port, 0);
    }

    public String getCurrentline() {
        return this.currentLine;
    }

    public String getCurrentmessage() {
        return this.currentMessage;
    }

    public int getCurrentStatus() {
        return this.currentStatus;
    }

    public int getCurrentStatusType() {
        return this.currentStatusType;
    }

    public void twoWay() throws Exception {
        this.cmd("2way");
        this.goesBothWays = true;
    }

    public void pagerID(String id) throws Exception {
        this.cmd("page " + id);
    }

    public void message(String msg) throws Exception {
        String tmp = "";
        String[] atmp = SpyUtil.split("\r\n", msg);
        for (int i = 0; i < atmp.length; ++i) {
            tmp = tmp + atmp[i] + " ";
        }
        this.cmd("mess " + tmp);
    }

    public void data(String msg) throws Exception {
        block2: {
            try {
                this.cmd("data");
            }
            catch (Exception e) {
                if (this.currentStatusType == 3) break block2;
                throw e;
            }
        }
        this.cmd(msg + "\r\n.");
    }

    public String getTag() {
        return this.msgTag;
    }

    public void sendpage(String id, String msg) throws Exception {
        this.cmd("rese");
        if (this.goesBothWays) {
            this.twoWay();
        }
        this.pagerID(id);
        this.message(msg);
        try {
            this.cmd("priority high");
        }
        catch (Exception e) {
            this.getLogger().debug("Failed to set priority");
        }
        this.send();
    }

    public void send() throws Exception {
        this.cmd("send");
        if (this.goesBothWays && this.currentStatusType == 8) {
            String[] a = SpyUtil.split(" ", this.currentMessage);
            this.msgTag = a[0] + " " + a[1];
        }
    }

    public String getResponse(String tag) throws Exception {
        String ret = null;
        if (this.goesBothWays) {
            this.cmd("msta " + tag);
            if (this.currentStatus == 889) {
                String tmp = this.currentMessage;
                tmp = tmp.substring(tmp.indexOf(" ")).trim();
                tmp = tmp.substring(tmp.indexOf(" ")).trim();
                ret = tmp = tmp.substring(tmp.indexOf(" ")).trim();
            }
        } else {
            throw new Exception("I don't go both ways.");
        }
        return ret;
    }

    public String getResponse() throws Exception {
        if (this.msgTag == null) {
            throw new Exception("No msg tag received, have you done a 2way page yet?");
        }
        return this.getResponse(this.msgTag);
    }

    public void addResponse(String response) throws Exception {
        if (!this.goesBothWays) {
            throw new Exception("I don't go both ways.");
        }
        this.cmd("mcre " + response);
    }

    public void cmd(String command) throws Exception {
        this.getLogger().debug(">> %s", command);
        this.prout.print(command + "\r\n");
        this.prout.flush();
        this.getaline();
        if (!this.ok()) {
            throw new Exception(this.currentMessage + " (" + command + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.socket != null) {
            try {
                this.cmd("quit");
            }
            catch (Exception e) {
                this.getLogger().warn((Object)"Exception while quitting", e);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    this.getLogger().warn((Object)"Exception while quitting", e);
                }
            }
            this.socket = null;
        }
    }

    protected void finalize() throws Throwable {
        this.getLogger().debug("Finalizing...");
        this.close();
        super.finalize();
    }

    private boolean ok() {
        boolean rv = false;
        if (this.currentStatusType == 2) {
            rv = true;
        }
        if (this.goesBothWays && !rv) {
            if (this.currentStatusType == 8) {
                rv = true;
            } else if (this.currentStatusType == 9) {
                rv = true;
            }
        }
        return rv;
    }

    private void getaline() throws IOException {
        this.currentLine = this.din.readLine();
        if (this.currentLine == null) {
            throw new IOException("Read returned null, disconnected?");
        }
        this.getLogger().debug("<< %s", this.currentLine);
        this.currentMessage = this.currentLine.substring(4);
        String stmp = this.currentLine.substring(0, 3);
        this.currentStatus = Integer.parseInt(stmp);
        stmp = this.currentLine.substring(0, 1);
        this.currentStatusType = Integer.parseInt(stmp);
    }
}

