/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Properties;
import net.spy.pool.JDBCPoolAble;
import net.spy.pool.PoolAble;
import net.spy.pool.PoolException;
import net.spy.pool.PoolFiller;
import net.spy.util.SpyConfig;

public class JDBCPoolFiller
extends PoolFiller {
    private String source = null;
    private Properties dbProps = null;
    private long maxAge = 0L;

    public JDBCPoolFiller(String name, SpyConfig conf) throws PoolException {
        super(name, conf);
        this.initialize();
    }

    private void setDBOptions(Properties from, Properties tmpconf, String base) {
        Enumeration<?> e = from.propertyNames();
        while (e.hasMoreElements()) {
            String pname = (String)e.nextElement();
            if (!pname.startsWith(base)) continue;
            String oname = pname.substring(base.length());
            String ovalue = from.getProperty(pname);
            tmpconf.put(oname, ovalue);
        }
    }

    private void initialize() throws PoolException {
        try {
            String classname = this.getProperty("dbDriverName");
            if (classname == null) {
                throw new Exception("No dbDriverName property given");
            }
            Class.forName(classname);
            this.source = this.getProperty("dbSource");
            if (this.source == null) {
                throw new Exception("No dbSource property given");
            }
            this.dbProps = new Properties();
            this.dbProps.put("user", this.getProperty("dbUser", ""));
            this.dbProps.put("password", this.getProperty("dbPass", ""));
            Properties sysprop = System.getProperties();
            this.setDBOptions(sysprop, this.dbProps, "dboption.");
            this.setDBOptions(this.getConfig(), this.dbProps, this.getName() + ".dboption.");
            this.maxAge = this.getPropertyInt("max_age", 0);
        }
        catch (Exception e) {
            throw new PoolException("Problem initializing pool filler", e);
        }
    }

    public PoolAble getObject() throws PoolException {
        JDBCPoolAble p = null;
        try {
            Connection db = DriverManager.getConnection(this.source, this.dbProps);
            p = new JDBCPoolAble(db, this.maxAge, this.getPoolHash());
        }
        catch (Exception e) {
            throw new PoolException("Error getting new DB object for the " + this.debugName() + " pool:  " + e);
        }
        return p;
    }
}

