/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.spy.SpyObject;
import net.spy.SpyThread;
import net.spy.pool.NoSuchPoolException;
import net.spy.pool.PoolContainer;
import net.spy.pool.PoolException;
import net.spy.pool.PoolFiller;
import net.spy.pool.PooledObject;
import net.spy.util.SpyConfig;
import net.spy.util.TimeStampedHashMap;

public class ObjectPool
extends SpyObject {
    private static final int TOSTRING_LEN = 256;
    private static final int NUM_CLEANS = 6;
    private static final int TIME_BETWEEN_CLEANS = 300000;
    private static ObjectPoolCleaner cleaner = null;
    private static TimeStampedHashMap<String, PoolContainer> pools = null;

    public ObjectPool(SpyConfig conf) {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPool(String name, PoolFiller pf) throws PoolException {
        TimeStampedHashMap<String, PoolContainer> timeStampedHashMap = pools;
        synchronized (timeStampedHashMap) {
            if (this.hasPool(name)) {
                throw new PoolException("There's already a pool called " + name);
            }
            PoolContainer pc = new PoolContainer(name, pf);
            pools.put(name, pc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPool(String name) throws PoolException {
        TimeStampedHashMap<String, PoolContainer> timeStampedHashMap = pools;
        synchronized (timeStampedHashMap) {
            ObjectPool.getPool(name);
            pools.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPool(String name) {
        boolean ret = false;
        TimeStampedHashMap<String, PoolContainer> timeStampedHashMap = pools;
        synchronized (timeStampedHashMap) {
            ret = pools.containsKey(name);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject getObject(String name) throws PoolException {
        PooledObject ret = null;
        PoolContainer pc = null;
        this.checkCleaner();
        TimeStampedHashMap<String, PoolContainer> timeStampedHashMap = pools;
        synchronized (timeStampedHashMap) {
            pc = ObjectPool.getPool(name);
        }
        ret = pc.getObject();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numPools() {
        int rv = 0;
        TimeStampedHashMap<String, PoolContainer> timeStampedHashMap = pools;
        synchronized (timeStampedHashMap) {
            rv = pools.size();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder out = new StringBuilder(256);
        ArrayList<PoolContainer> a = new ArrayList<PoolContainer>();
        TimeStampedHashMap<String, PoolContainer> timeStampedHashMap = pools;
        synchronized (timeStampedHashMap) {
            for (PoolContainer pc : pools.values()) {
                a.add(pc);
            }
        }
        for (PoolContainer pc : a) {
            out.append(pc);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune() throws PoolException {
        ArrayList<PoolContainer> a = new ArrayList<PoolContainer>(pools.size());
        TimeStampedHashMap<String, PoolContainer> timeStampedHashMap = pools;
        synchronized (timeStampedHashMap) {
            Iterator i = pools.values().iterator();
            while (i.hasNext()) {
                PoolContainer pc = (PoolContainer)i.next();
                if (pc.totalObjects() == 0) {
                    i.remove();
                    continue;
                }
                a.add(pc);
            }
        }
        for (PoolContainer pc : a) {
            pc.prune();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized PoolContainer getPool(String name) throws PoolException {
        PoolContainer ret = null;
        TimeStampedHashMap<String, PoolContainer> timeStampedHashMap = pools;
        synchronized (timeStampedHashMap) {
            ret = pools.get(name);
            if (ret == null) {
                throw new NoSuchPoolException(name);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Class<ObjectPool> clazz = ObjectPool.class;
        synchronized (ObjectPool.class) {
            if (pools == null) {
                pools = new TimeStampedHashMap();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.checkCleaner();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCleaner() {
        Class<ObjectPool> clazz = ObjectPool.class;
        synchronized (ObjectPool.class) {
            if (cleaner == null || !cleaner.isAlive()) {
                cleaner = new ObjectPoolCleaner(this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class ObjectPoolCleaner
    extends SpyThread {
        private ObjectPool op = null;
        private int numCleans = 0;
        private Date lastClean = null;

        public ObjectPoolCleaner(ObjectPool o) {
            this.op = o;
            this.setDaemon(true);
            this.setName("ObjectPoolCleaner");
            this.start();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(256);
            sb.append(super.toString());
            sb.append(" - ");
            sb.append(this.numCleans);
            sb.append(" served");
            if (this.lastClean != null) {
                sb.append(".  Most recent cleaning:  ");
                sb.append(this.lastClean);
            }
            return sb.toString();
        }

        private void doPrune() throws Exception {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Cleaning pool:  " + this.op);
            }
            this.op.prune();
            ++this.numCleans;
            this.getLogger().debug("Finished cleaning, looks like this:  %s", this.op);
        }

        public void run() {
            while (this.numCleans < 6) {
                try {
                    ObjectPoolCleaner.sleep(300000L);
                    this.lastClean = new Date();
                    this.doPrune();
                }
                catch (Exception e) {
                    this.getLogger().error((Object)"Cleaner got an exception", e);
                }
            }
        }
    }
}

