/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import net.spy.util.LoopingThread;
import net.spy.util.RunnableRunner;

class WorkerThread
extends LoopingThread
implements RunnableRunner {
    private Runnable theRunnable = null;

    WorkerThread(ThreadGroup tg, String name) {
        super(tg, name);
        this.setDaemon(true);
        this.setMsPerLoop(300000);
        this.start();
    }

    public String toString() {
        Runnable tmp = this.theRunnable;
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.toString());
        if (tmp != null) {
            sb.append(" - running ");
            sb.append(tmp);
        } else {
            sb.append(" - idle");
        }
        return sb.toString();
    }

    public synchronized void run(Runnable r) {
        if (this.theRunnable != null) {
            throw new IllegalStateException("Already has a valid runnable.");
        }
        this.theRunnable = r;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void runLoop() {
        if (this.theRunnable != null) {
            try {
                this.theRunnable.run();
            }
            catch (RuntimeException e) {
                this.getLogger().error((Object)"Problem processing job", e);
            }
            finally {
                this.theRunnable = null;
            }
        }
    }
}

