/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

public class Base64 {
    private static final char[] CHARMAP = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static Base64 instance = null;

    public static Base64 getInstance() {
        if (instance == null) {
            instance = new Base64();
        }
        return instance;
    }

    public String encode(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 4 / 3);
        int o = 0;
        for (int i = 0; i < data.length; i += 3) {
            int a = data[i] & 0xFF;
            sb.append(CHARMAP[a >> 2]);
            int tmpa = (a & 3) << 4;
            if (data.length > i + 1) {
                int b = data[i + 1] & 0xFF;
                int tmpb = b >> 4;
                sb.append(CHARMAP[tmpa | tmpb]);
                tmpa = (b & 0xF) << 2;
                if (data.length > i + 2) {
                    int c = data[i + 2] & 0xFF;
                    tmpb = (c & 0xC0) >> 6;
                    sb.append(CHARMAP[tmpa | tmpb]);
                    sb.append(CHARMAP[c & 0x3F]);
                } else {
                    sb.append(CHARMAP[tmpa]);
                    sb.append('=');
                }
            } else {
                sb.append(CHARMAP[tmpa]);
                sb.append('=');
                sb.append('=');
            }
            if ((o += 4) % 76 != 0) continue;
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public byte[] decode(String input) {
        int size = input.length() * 3 / 4;
        int insize = input.length();
        if (input.endsWith("=")) {
            --size;
            --insize;
            if (input.endsWith("==")) {
                --size;
                --insize;
            }
        }
        byte[] rv = new byte[size];
        int pos = 0;
        int count = 0;
        int packer = 0;
        int invalid = 0;
        for (int i = 0; i < insize; ++i) {
            int x = this.mapIndex(input.charAt(i));
            if (x < 0) {
                ++invalid;
                continue;
            }
            packer = packer << 6 | x;
            if (++count != 4) continue;
            rv[pos++] = (byte)(packer >> 16 & 0xFF);
            rv[pos++] = (byte)(packer >> 8 & 0xFF);
            rv[pos++] = (byte)(packer & 0xFF);
            count = 0;
            packer = 0;
        }
        if (count == 2) {
            rv[pos++] = (byte)(packer << 12 >> 16 & 0xFF);
        } else if (count == 3) {
            rv[pos++] = (byte)(packer << 6 >> 16 & 0xFF);
            rv[pos++] = (byte)(packer << 6 >> 8 & 0xFF);
        }
        if (invalid > 0) {
            byte[] tmp = new byte[pos];
            System.arraycopy(rv, 0, tmp, 0, pos);
            rv = tmp;
        }
        return rv;
    }

    public boolean isValidBase64Char(char c) {
        return this.mapIndex(c) >= 0;
    }

    private int mapIndex(char c) {
        int rv = -1;
        for (int i = 0; i < CHARMAP.length && rv == -1; ++i) {
            if (CHARMAP[i] != c) continue;
            rv = i;
        }
        return rv;
    }
}

