/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.spy.util.Base64;

public class Base64OutputStream
extends FilterOutputStream {
    private Base64 base64 = new Base64();
    private int currentByte = 0;
    private int currentOutput = 0;
    private byte[] buffer = new byte[3];
    private byte[] crlf = new byte[2];

    public Base64OutputStream(OutputStream os) {
        super(os);
        this.crlf[0] = 13;
        this.crlf[1] = 10;
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.write(data[i]);
        }
    }

    public void close() throws IOException {
        if (this.currentByte > 0) {
            byte[] tmp = new byte[this.currentByte];
            System.arraycopy(this.buffer, 0, tmp, 0, this.currentByte);
            this.out.write(this.base64.encode(tmp).getBytes());
            this.out.write(this.crlf);
            this.currentByte = 0;
            this.currentOutput = 0;
        } else if (this.currentOutput != 0) {
            this.out.write(this.crlf);
        }
        super.close();
    }

    public void write(byte datum) throws IOException {
        this.buffer[this.currentByte++] = datum;
        if (this.currentByte == 3) {
            this.out.write(this.base64.encode(this.buffer).getBytes());
            this.currentByte = 0;
            this.currentOutput += 4;
        }
        if (this.currentOutput == 76) {
            this.currentOutput = 0;
            this.out.write(this.crlf);
        }
    }
}

