/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import net.spy.SpyObject;
import net.spy.util.CloseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceImplementor
extends SpyObject {
    private HashSet<String> definedFunctions = null;
    private Class<?> interfaceClass = null;
    private Class<?> superClass = null;
    private String outpackage = null;
    private String outclass = "BLAH";

    public InterfaceImplementor(Class<?> c) {
        if (c == null) {
            throw new NullPointerException("Null interface is invalid.");
        }
        if (!c.isInterface()) {
            throw new IllegalArgumentException("Passed in class is not an interface.");
        }
        this.definedFunctions = new HashSet();
        this.interfaceClass = c;
    }

    protected Class<?> getInterface() {
        return this.interfaceClass;
    }

    protected Class<?> getSuperclass() {
        return this.superClass;
    }

    public String getOutClassName() {
        return this.outclass;
    }

    public String getOutPackageName() {
        return this.outpackage;
    }

    public void setOutputClass(String to) {
        int lastdot = to.lastIndexOf(".");
        if (lastdot == -1) {
            this.outclass = to;
        } else {
            this.outpackage = to.substring(0, lastdot);
            this.outclass = to.substring(lastdot + 1);
        }
    }

    public void setSuperClass(Class<?> c) {
        if (c == null) {
            throw new NullPointerException("Null class is invalid.");
        }
        int modifiers = c.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            throw new IllegalArgumentException("You can't extend from final classes.");
        }
        if (Modifier.isInterface(modifiers)) {
            throw new IllegalArgumentException("Interfaces aren't valid here.");
        }
        this.superClass = c;
        this.getMethods(c);
    }

    private void getMethods(Class<?> c) {
        int modifiers;
        int i;
        Method[] methods = c.getDeclaredMethods();
        for (i = 0; i < methods.length; ++i) {
            modifiers = methods[i].getModifiers();
            if (Modifier.isAbstract(modifiers)) continue;
            this.definedFunctions.add(this.getSignature(methods[i]));
        }
        methods = c.getMethods();
        for (i = 0; i < methods.length; ++i) {
            modifiers = methods[i].getModifiers();
            if (Modifier.isAbstract(modifiers)) continue;
            this.definedFunctions.add(this.getSignature(methods[i]));
        }
    }

    private String decodeType(Class<?> type) {
        String rv = null;
        rv = type.isArray() ? this.decodeType(type.getComponentType()) + "[]" : type.getName();
        return rv;
    }

    protected String getSignature(Method method) {
        return this.getSignature(method, true);
    }

    protected String getSignature(Method method, boolean needExceptions) {
        String ret = "";
        int modifiers = method.getModifiers();
        ret = Modifier.toString(modifiers &= 0xFFFFFBFF);
        Class<?> rt = method.getReturnType();
        ret = ret + " " + this.decodeType(rt) + " ";
        String name = method.getName();
        Class<?>[] types = method.getParameterTypes();
        ret = ret + name + "(";
        if (types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                ret = ret + this.decodeType(types[i]) + " a" + i + ", ";
            }
            ret = ret.substring(0, ret.length() - 2);
        }
        ret = ret + ") ";
        if (needExceptions) {
            ret = ret + this.getExSignature(method);
        }
        return ret.trim();
    }

    protected String getDocLink(Method method) {
        String ret = method.getName();
        Class<?>[] types = method.getParameterTypes();
        ret = ret + "(";
        if (types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                ret = ret + this.decodeType(types[i]);
                ret = ret + ",";
            }
            ret = ret.substring(0, ret.length() - 1);
        }
        ret = ret + ")";
        return ret;
    }

    private String getExSignature(Method method) {
        String ret = "";
        Class<?>[] e = method.getExceptionTypes();
        if (e.length > 0) {
            ret = ret + "\n\t\tthrows ";
            for (int i = 0; i < e.length; ++i) {
                ret = ret + e[i].getName() + ",";
            }
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private String getSignature(Constructor<?> con) {
        String ret = null;
        int modifiers = con.getModifiers();
        ret = Modifier.toString(modifiers) + " " + this.outclass;
        Class<?>[] types = con.getParameterTypes();
        ret = ret + "(";
        if (types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                ret = ret + this.decodeType(types[i]) + " a" + i + ", ";
            }
            ret = ret.substring(0, ret.length() - 2);
        }
        ret = ret + ") ";
        Class<?>[] e = con.getExceptionTypes();
        if (e.length > 0) {
            ret = ret + "\n\t\tthrows ";
            for (int i = 0; i < e.length; ++i) {
                ret = ret + e[i].getName() + ", ";
            }
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    protected String getDocLink(Constructor<?> con) {
        String ret = con.getName();
        Class<?>[] types = con.getParameterTypes();
        ret = ret + "(";
        if (types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                ret = ret + this.decodeType(types[i]);
                ret = ret + ",";
            }
            ret = ret.substring(0, ret.length() - 1);
        }
        ret = ret + ")";
        return ret;
    }

    protected String implement(Method method) {
        String ret = "\t/**\n\t * InterfaceImplementor implementation of " + method.getName() + ".\n" + "\t * @see " + this.interfaceClass.getName() + "#" + this.getDocLink(method) + "\n" + "\t */\n";
        ret = ret + "\t" + this.getSignature(method) + " {\n";
        Class<?>[] e = method.getExceptionTypes();
        if (e.length > 0) {
            ret = ret + "\t\tthrow new " + e[0].getName() + "(\"" + this.getSignature(method, false) + " not implemented yet.\");\n";
        } else {
            Class<?> rt = method.getReturnType();
            if (rt.isPrimitive()) {
                if (rt == Boolean.TYPE) {
                    ret = ret + "\t\treturn false;\n";
                } else if (rt != Void.TYPE) {
                    ret = ret + "\t\treturn 0;\n";
                }
            } else {
                ret = ret + "\t\treturn null;\n";
            }
        }
        ret = ret + "\t}\n\n";
        return ret;
    }

    private String implementConstructor(Constructor<?> con) {
        String ret = "\t/**\n\t * Constructor provided by InterfaceImplementor.\n";
        if (this.superClass != null) {
            ret = ret + "\t * @see " + this.superClass.getName() + "#" + this.getDocLink(con) + "\n";
        }
        ret = ret + "\t */\n";
        ret = ret + "\t" + this.getSignature(con) + " {\n";
        ret = ret + "\t\tsuper(";
        Class<?>[] params = con.getParameterTypes();
        if (params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                ret = ret + "a" + i + ", ";
            }
            ret = ret.substring(0, ret.length() - 2);
        }
        ret = ret + ");\n\t}\n\n";
        return ret;
    }

    protected String preConstructors() {
        return null;
    }

    protected String preMethods() {
        return null;
    }

    public String makeSource() {
        String pm;
        String ret = "";
        if (this.outpackage != null) {
            ret = ret + "package " + this.outpackage + ";\n\n";
        }
        ret = ret + "/**\n * InterfaceImplementor implementation of " + this.interfaceClass.getName() + ".\n" + " */\n";
        ret = ret + "public class " + this.outclass + " ";
        if (this.superClass != null) {
            ret = ret + "extends " + this.superClass.getName() + " ";
        }
        ret = ret + "implements " + this.interfaceClass.getName() + " {\n\n";
        String pc = this.preConstructors();
        if (pc != null) {
            ret = ret + pc;
        }
        if (this.superClass != null && this.buildConstructors()) {
            Constructor<?>[] constructors = this.superClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                ret = ret + this.implementConstructor(constructors[i]);
            }
        }
        if ((pm = this.preMethods()) != null) {
            ret = ret + pm;
        }
        Method[] methods = this.interfaceClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String sig = this.getSignature(methods[i]);
            if (this.definedFunctions.contains(sig)) continue;
            ret = ret + this.implement(methods[i]);
        }
        ret = ret + "}\n";
        return ret;
    }

    protected boolean buildConstructors() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSourceToFile(String outdir) throws IOException {
        String fn = outdir + File.separatorChar;
        String op = this.getOutPackageName();
        String oc = this.getOutClassName();
        if (op != null) {
            File packagepath = new File(fn + op.replace('.', File.separatorChar));
            packagepath.mkdirs();
            fn = packagepath.toString() + File.separatorChar;
        }
        fn = fn + oc + ".java";
        System.out.println("Writing output to " + fn);
        FileWriter fw = new FileWriter(fn);
        try {
            fw.write(this.makeSource());
        }
        finally {
            CloseUtil.close(fw);
        }
    }

    private static void usage() {
        System.err.println("Usage:  InterfaceImplementor -interface className [-superclass className]\n\t[-outputdir outputDir] [-outputclass className]");
    }

    public static void main(String[] args) throws Exception {
        String superclassName = null;
        String interfaceName = null;
        String outclass = null;
        String outdir = ".";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-superclass")) {
                superclassName = args[++i];
                continue;
            }
            if (args[i].equals("-interface")) {
                interfaceName = args[++i];
                continue;
            }
            if (args[i].equals("-outputclass")) {
                outclass = args[++i];
                continue;
            }
            if (args[i].equals("-outputdir")) {
                outdir = args[++i];
                continue;
            }
            System.err.println("Unknown argument:  " + args[i]);
            InterfaceImplementor.usage();
            throw new Exception("Unknown argument:  " + args[i]);
        }
        if (interfaceName == null) {
            System.err.println("No superinterface given.");
            InterfaceImplementor.usage();
            throw new Exception("No superinterface given.");
        }
        InterfaceImplementor i = new InterfaceImplementor(Class.forName(interfaceName));
        if (superclassName != null) {
            System.out.println("Loading super class:  " + superclassName);
            i.setSuperClass(Class.forName(superclassName));
        }
        if (outclass != null) {
            i.setOutputClass(outclass);
            i.writeSourceToFile(outdir);
        } else {
            System.out.print(i.makeSource());
        }
    }
}

