/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.text.MessageFormat;
import java.util.Date;

public class ProgressStats {
    private static final String DEFAULT_FORMAT = "{5} remaining.  Avg={0,number,#.##}s, Estimate={1,number,#.##}s ({2,date,EEE MMMdd HH:mm:ss})";
    private int done = 0;
    private int todo = 0;
    private long totalTime = 0L;
    private long lastTime = 0L;
    private long lastProcessTime = 0L;
    private double avg = 0.0;

    public ProgressStats(int size) {
        this.todo = size;
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }

    public void start() {
        this.lastTime = this.getTime();
    }

    public void stop() {
        long thistime = this.getTime();
        this.lastProcessTime = thistime - this.lastTime;
        ++this.done;
        this.totalTime += this.lastProcessTime;
        double df = this.done;
        double v = (double)this.lastProcessTime / 1000.0;
        this.avg = (this.avg * df + v) / (df + 1.0);
    }

    public double getRunningAverage() {
        return this.avg;
    }

    public double getOverallAverage() {
        double avgProcessTime = (double)this.totalTime / (double)this.done / 1000.0;
        return avgProcessTime;
    }

    public double getEstimatedTimeRemaining(double avgProcessTime) {
        double estimate = avgProcessTime * (double)(this.todo - this.done);
        return estimate;
    }

    public double getEstimatedTimeRemaining() {
        return this.getEstimatedTimeRemaining(this.getRunningAverage());
    }

    public long getLastProcessTime() {
        return this.lastProcessTime;
    }

    public String getStats(String format) {
        double average = this.getRunningAverage();
        double estimate = this.getEstimatedTimeRemaining(average);
        Date ofCompletion = new Date(this.getTime() + 1000L * (long)estimate);
        Object[] args = new Object[]{new Double(average), new Double(estimate), ofCompletion, new Integer(this.done), new Integer(this.todo), new Integer(this.todo - this.done)};
        String rv = MessageFormat.format(format, args);
        return rv;
    }

    public String getStats() {
        return this.getStats(DEFAULT_FORMAT);
    }

    public String toString() {
        return this.getStats();
    }
}

