/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.util.ArrayList;
import net.spy.util.NoPathException;
import net.spy.util.SPNode;
import net.spy.util.SPVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortestPath<N extends SPNode<N>>
extends ArrayList<N> {
    private int cost = 0;

    public ShortestPath(N from, N to) throws NoPathException {
        if (from == null) {
            throw new NullPointerException("From may not be null.");
        }
        if (to == null) {
            throw new NullPointerException("To may not be null.");
        }
        SPVertex v = from.getNextHop(to);
        if (v == null) {
            throw new NoPathException((SPNode<?>)from, (SPNode<?>)to);
        }
        this.cost = v.getCost();
        Object current = v.getTo();
        int i = 0;
        while (!current.equals(to)) {
            if (++i > 1024) {
                throw new NoPathException((SPNode<?>)from, (SPNode<?>)to, "Too deep!");
            }
            this.add(current);
            v = current.getNextHop(to);
            current = v.getTo();
        }
        this.add(current);
    }

    public int getCost() {
        return this.cost;
    }
}

