/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.spy.util.CloseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyConfig
extends Properties {
    private static Map<File, ConfigInfo> configStore = null;

    public SpyConfig(File conffile) {
        SpyConfig.confInit();
        this.loadConfig(conffile);
    }

    public SpyConfig() {
        SpyConfig.confInit();
    }

    private static synchronized void confInit() {
        if (configStore == null) {
            configStore = Collections.synchronizedMap(new HashMap());
        }
    }

    public boolean loadConfig(File conffile) {
        boolean loaded = false;
        if (this.isUpToDate(conffile)) {
            ConfigInfo ci = configStore.get(conffile);
            this.set(ci.getConfig());
            loaded = true;
        } else {
            try {
                Map<String, String> h = this.mapConfig(conffile);
                this.record(conffile, h);
                this.set(h);
                loaded = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return loaded;
    }

    public boolean loadConfig(File[] confFiles) {
        boolean gotit = false;
        for (int i = 0; i < confFiles.length && !gotit; ++i) {
            gotit = this.loadConfig(confFiles[i]);
        }
        return gotit;
    }

    private boolean isUpToDate(File file) {
        boolean r = false;
        ConfigInfo ci = configStore.get(file);
        if (ci != null && ci.getTimestamp() == file.lastModified()) {
            r = true;
        }
        return r;
    }

    private void record(File file, Map<String, String> h) {
        configStore.put(file, new ConfigInfo(h, file.lastModified()));
    }

    private void set(Map<String, String> h) {
        for (Map.Entry<String, String> me : h.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    public String get(String key) {
        return (String)super.get(key);
    }

    public String get(String key, String def) {
        String ret = this.get(key);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public int getInt(String key, int def) {
        String value = this.get(key);
        int r = def;
        if (value != null) {
            r = Integer.parseInt(value);
        }
        return r;
    }

    public void orput(String key, String value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> mapConfig(File file) throws IOException {
        Properties p = new Properties();
        FileInputStream fis = new FileInputStream(file);
        try {
            p.load(fis);
        }
        finally {
            CloseUtil.close(fis);
        }
        return new HashMap<Object, Object>(p);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigInfo {
        private long timestamp = 0L;
        private Map<String, String> config = null;

        public ConfigInfo(Map<String, String> m, long ts) {
            this.config = m;
            this.timestamp = ts;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }
    }
}

