/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.spy.log.LoggerFactory;
import net.spy.util.CloseUtil;
import net.spy.util.Enumeriterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyUtil {
    private SpyUtil() {
    }

    public static Object[] shuffle(Object[] in) {
        Object[] ret = new Object[in.length];
        System.arraycopy(in, 0, ret, 0, in.length);
        SecureRandom r = new SecureRandom();
        for (int i = 0; i < ret.length; ++i) {
            int n = r.nextInt();
            if (n < 0) {
                n = -n;
            }
            Object tmp = ret[i];
            ret[i] = ret[n %= ret.length];
            ret[n] = tmp;
        }
        return ret;
    }

    public static String[] split(String on, String input) {
        StringTokenizer st = new StringTokenizer(input, on);
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i++] = st.nextToken();
        }
        return ret;
    }

    public static String getReaderAsString(Reader r) throws IOException {
        int size;
        char[] c = new char[8192];
        StringBuilder rv = new StringBuilder(8192);
        while ((size = r.read(c)) >= 0) {
            String tmp = new String(c);
            rv.append(tmp.substring(0, size));
        }
        return rv.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileData(File file) throws IOException {
        FileReader f = new FileReader(file);
        String rv = null;
        try {
            rv = SpyUtil.getReaderAsString(f);
        }
        finally {
            CloseUtil.close(f);
        }
        return rv;
    }

    public static <T> String join(Enumeration<T> e, String on) {
        return SpyUtil.join(new Enumeriterator<T>(e), on);
    }

    public static String join(Iterator<?> i, String on) {
        StringBuilder sb = new StringBuilder(256);
        while (i.hasNext()) {
            Object o = i.next();
            sb.append(o);
            if (!i.hasNext()) continue;
            sb.append(on);
        }
        return sb.toString();
    }

    public static String join(Collection<?> c, String on) {
        return SpyUtil.join(c.iterator(), on);
    }

    public static String byteAToHexString(byte[] me) {
        StringBuilder sb = new StringBuilder(me.length * 2);
        for (byte b : me) {
            int bai = b & 0xFF;
            if (bai < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(bai));
        }
        return sb.toString();
    }

    public static void runClass(String classname, String[] args) throws Exception {
        SpyUtil.runClass(SpyUtil.class.getClassLoader(), classname, args);
    }

    public static void runClass(ClassLoader cl, String classname, String[] args) throws Exception {
        Class<?> tclass = Class.forName(classname, true, cl);
        Class[] paramtypes = new Class[1];
        String[] tmp = new String[]{};
        paramtypes[0] = tmp.getClass();
        Method m = tclass.getMethod("main", paramtypes);
        Object[] params = new Object[]{args};
        try {
            m.invoke(tclass, params);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            Throwable t = ite.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            t.printStackTrace();
        }
    }

    public static Boolean getBoolean(String s) {
        Boolean rv = Boolean.FALSE;
        if (s != null && s.equalsIgnoreCase("true")) {
            rv = Boolean.TRUE;
        }
        return rv;
    }

    public static String deHTML(String contents) {
        char[] chars;
        int inTag = 0;
        StringBuilder sb = new StringBuilder(contents.length());
        for (char c : chars = contents.toCharArray()) {
            if (c == '<') {
                ++inTag;
                continue;
            }
            if (c == '>' && inTag > 0) {
                if (inTag < 1) continue;
                --inTag;
                continue;
            }
            if (inTag != 0) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static void rmDashR(File tmp) {
        File[] f = tmp.listFiles();
        if (f != null) {
            for (int i = 0; i < f.length; ++i) {
                if (f[i].isDirectory()) {
                    SpyUtil.rmDashR(f[i]);
                    continue;
                }
                if (f[i].delete()) continue;
                LoggerFactory.getLogger(SpyUtil.class).warn("Couldn't delete " + f[i]);
            }
        }
        if (!tmp.delete()) {
            LoggerFactory.getLogger(SpyUtil.class).warn("Couldn't delete " + tmp);
        }
    }
}

