/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimerTask;
import net.spy.log.Logger;
import net.spy.log.LoggerFactory;

public class TTL
extends TimerTask {
    private static final int DEFAULT_REPORT_INTERVAL = 300000;
    private static final int DEFAULT_N_REPORTS = 10;
    private long ttl = 0L;
    private long startTime = 0L;
    private Expired e = null;
    private Object extraInfo = null;
    private boolean isClosed = false;
    private boolean fired = false;
    private int nReports = 0;
    private int reportInterval = 300000;
    private int maxNReports = 10;
    private transient Logger logger = null;

    public TTL(long theTTL) {
        this(theTTL, null);
    }

    public TTL(long theTTL, Object info) {
        this.ttl = theTTL;
        this.extraInfo = info;
        this.reset();
        this.e = new Expired();
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
    }

    public String toString() {
        return "TTL:  " + this.ttl + "@" + System.identityHashCode(this);
    }

    public long getTTL() {
        return this.ttl;
    }

    public void setReportInterval(int ms) {
        this.reportInterval = ms;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public void setMaxReports(int to) {
        this.maxNReports = to;
    }

    public synchronized boolean hasReported() {
        return this.nReports > 0;
    }

    public void setExtraInfo(Object o) {
        this.extraInfo = o;
    }

    public Object getExtraInfo() {
        return this.extraInfo;
    }

    public synchronized void close() {
        this.isClosed = true;
        this.cancel();
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean isExpired() {
        return this.fired;
    }

    protected void reportWithFormat(String msg) {
        long now = System.currentTimeMillis();
        Object[] args = new Object[]{new Long(now - this.startTime), new Long(this.ttl), this.extraInfo};
        MessageFormat mf = new MessageFormat(msg);
        String toLog = mf.format(args);
        this.getLogger().warn((Object)toLog, this.e);
    }

    protected String getMessageFromBundle(String bundleName, String msgNoArg, String msgWithArg) {
        String rv = null;
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(bundleName);
        }
        catch (MissingResourceException ex) {
            rv = "ResourceBundle not found while reporting TTL expiration:  " + bundleName + ".  (Expected {1}ms, been {0}ms).";
        }
        if (rb != null) {
            try {
                rv = this.extraInfo == null ? rb.getString(msgNoArg) : rb.getString(msgWithArg);
            }
            catch (MissingResourceException ex) {
                rv = "Resource not found while reporting TTL expiration:  " + ex.getKey() + ".  (Expected {1}ms, been {0}ms).";
            }
        }
        return rv;
    }

    protected void doReport() {
        String msg = this.getMessageFromBundle("net.spy.util.messages", "ttl.msg", "ttl.msg.witharg");
        this.reportWithFormat(msg);
    }

    public final synchronized void run() {
        this.fired = true;
        this.doReport();
        if (this.nReports++ >= this.maxNReports) {
            this.close();
        }
    }

    private static class Expired
    extends Exception {
        public Expired() {
            super("Timer has expired.");
        }
    }
}

