/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.util.ArrayList;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.MessageEvaluationContext;

public class LastImageSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private volatile MessageReference lastImage;

    public boolean add(ConnectionContext context, MessageReference node) throws Exception {
        this.lastImage = node;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ConnectionContext context, Topic topic, Subscription sub) throws Exception {
        MessageReference node = this.lastImage;
        if (node != null) {
            MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
            try {
                msgContext.setDestination(node.getRegionDestination().getActiveMQDestination());
                msgContext.setMessageReference(node);
                if (sub.matches(node, msgContext)) {
                    sub.add(node);
                }
            }
            finally {
                msgContext.clear();
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public Message[] browse(ActiveMQDestination destination) throws Exception {
        ArrayList<Message> result = new ArrayList<Message>();
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        if (filter.matches(this.lastImage.getMessage().getDestination())) {
            result.add(this.lastImage.getMessage());
        }
        return result.toArray(new Message[result.size()]);
    }

    public SubscriptionRecoveryPolicy copy() {
        return new LastImageSubscriptionRecoveryPolicy();
    }
}

