/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.util.CommandMessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandAgent
implements Service,
BrokerServiceAware {
    private static final Log log = LogFactory.getLog(CommandAgent.class);
    private String brokerUrl = "vm://localhost";
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Destination commandDestination;
    private CommandMessageListener listener;
    private Session session;
    private MessageConsumer consumer;
    private String brokerName = "default";

    public void start() throws Exception {
        this.session = this.getConnection().createSession(false, 1);
        this.listener = new CommandMessageListener(this.session);
        Destination destination = this.getCommandDestination();
        if (log.isDebugEnabled()) {
            log.debug("Agent subscribing to control destination: " + destination);
        }
        this.consumer = this.session.createConsumer(destination);
        this.consumer.setMessageListener(this.listener);
    }

    public void stop() throws Exception {
        this.consumer.close();
        this.consumer = null;
        this.session.close();
        this.session = null;
        this.connection.close();
        this.connection = null;
    }

    public void setBrokerService(BrokerService brokerService) {
        String name = brokerService.getBrokerName();
        if (name != null) {
            this.brokerName = name;
        }
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ActiveMQConnectionFactory(this.brokerUrl);
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Destination getCommandDestination() {
        if (this.commandDestination == null) {
            this.commandDestination = this.createCommandDestination();
        }
        return this.commandDestination;
    }

    public void setCommandDestination(Destination commandDestination) {
        this.commandDestination = commandDestination;
    }

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    protected Destination createCommandDestination() {
        return AdvisorySupport.getAgentDestination(this.brokerName);
    }
}

