/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.console.filter.AbstractQueryFilter;

public class MBeansObjectNameQueryFilter
extends AbstractQueryFilter {
    public static final String DEFAULT_JMX_DOMAIN = "org.apache.activemq";
    public static final String QUERY_EXP_PREFIX = "MBeans.QueryExp.";
    private JMXServiceURL jmxServiceUrl;

    public MBeansObjectNameQueryFilter(String jmxUrl) throws MalformedURLException {
        this(new JMXServiceURL(jmxUrl));
    }

    public MBeansObjectNameQueryFilter(JMXServiceURL jmxUrl) {
        super(null);
        this.jmxServiceUrl = jmxUrl;
    }

    public List query(List queries) throws MalformedObjectNameException, IOException {
        if (queries == null || queries.isEmpty()) {
            return this.queryMBeans(new ObjectName("org.apache.activemq:*"), null);
        }
        String objNameQuery = "";
        String queryExp = "";
        Iterator i = queries.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String val = "";
            int pos = key.indexOf("=");
            if (pos >= 0) {
                val = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            if (val.startsWith(QUERY_EXP_PREFIX) || key == "" || val == "") continue;
            objNameQuery = objNameQuery + key + "=" + val + ",";
        }
        objNameQuery = objNameQuery + "*";
        return this.queryMBeans(new ObjectName("org.apache.activemq:" + objNameQuery), queryExp);
    }

    protected List queryMBeans(ObjectName objName, String queryExpStr) throws IOException {
        JMXConnector jmxConn = this.createJmxConnector();
        MBeanServerConnection server = jmxConn.getMBeanServerConnection();
        QueryExp queryExp = this.createQueryExp(queryExpStr);
        ArrayList mbeans = new ArrayList(server.queryMBeans(objName, queryExp));
        jmxConn.close();
        return mbeans;
    }

    public JMXServiceURL getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    public void setJmxServiceUrl(JMXServiceURL jmxServiceUrl) {
        this.jmxServiceUrl = jmxServiceUrl;
    }

    public void setJmxServiceUrl(String jmxServiceUrl) throws MalformedURLException {
        this.setJmxServiceUrl(new JMXServiceURL(jmxServiceUrl));
    }

    protected JMXConnector createJmxConnector() throws IOException {
        return JMXConnectorFactory.connect(this.getJmxServiceUrl());
    }

    protected QueryExp createQueryExp(String queryExpStr) {
        return null;
    }
}

