/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.container.BaseContainerImpl;
import org.apache.activemq.kaha.impl.container.CachedContainerListIterator;
import org.apache.activemq.kaha.impl.container.ContainerId;
import org.apache.activemq.kaha.impl.data.DataManager;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListContainerImpl
extends BaseContainerImpl
implements ListContainer {
    private static final Log log = LogFactory.getLog(ListContainerImpl.class);
    protected Marshaller marshaller = Store.ObjectMarshaller;
    protected LinkedList cacheList = new LinkedList();
    protected int offset = 0;
    protected int maximumCacheSize = 100;
    protected IndexItem lastCached;

    public ListContainerImpl(ContainerId id, IndexItem root, IndexManager indexManager, DataManager dataManager, String indexType) throws IOException {
        super(id, root, indexManager, dataManager, indexType);
    }

    public synchronized void load() {
        this.checkClosed();
        if (!this.loaded && !this.loaded) {
            this.loaded = true;
            try {
                this.init();
                long nextItem = this.root.getNextItem();
                while (nextItem != -1L) {
                    IndexItem item = this.indexManager.getIndex(nextItem);
                    this.indexList.add(item);
                    this.itemAdded(item, this.indexList.size() - 1, this.getValue(item));
                    nextItem = item.getNextItem();
                }
            }
            catch (IOException e) {
                log.error("Failed to load container " + this.getId(), e);
                throw new RuntimeStoreException(e);
            }
        }
    }

    public synchronized void unload() {
        this.checkClosed();
        if (this.loaded) {
            this.loaded = false;
            this.indexList.clear();
            this.clearCache();
        }
    }

    public synchronized void setMarshaller(Marshaller marshaller) {
        this.checkClosed();
        this.marshaller = marshaller;
    }

    public synchronized boolean equals(Object obj) {
        this.load();
        boolean result = false;
        if (obj != null && obj instanceof List) {
            List other = (List)obj;
            boolean bl = result = other.size() == this.size();
            if (result) {
                for (int i = 0; i < this.indexList.size(); ++i) {
                    Object o2;
                    Object o1 = other.get(i);
                    boolean bl2 = result = o1 == (o2 = this.get(i)) || o1 != null && o2 != null && o1.equals(o2);
                    if (!result) break;
                }
            }
        }
        return result;
    }

    public synchronized int size() {
        this.load();
        return this.indexList.size();
    }

    public synchronized void addFirst(Object o) {
        this.internalAddFirst(o);
    }

    public synchronized void addLast(Object o) {
        this.internalAddLast(o);
    }

    public synchronized Object removeFirst() {
        this.load();
        Object result = null;
        IndexItem item = this.indexList.getFirst();
        if (item != null) {
            this.itemRemoved(0);
            result = this.getValue(item);
            IndexItem prev = this.root;
            IndexItem next = this.indexList.size() > 1 ? this.indexList.get(1) : null;
            this.indexList.removeFirst();
            this.delete(item, prev, next);
            item = null;
        }
        return result;
    }

    public synchronized Object removeLast() {
        this.load();
        Object result = null;
        IndexItem last = this.indexList.getLast();
        if (last != null) {
            this.itemRemoved(this.indexList.size() - 1);
            result = this.getValue(last);
            IndexItem prev = this.indexList.getPrevEntry(last);
            IndexItem next = null;
            this.indexList.removeLast();
            this.delete(last, prev, next);
        }
        return result;
    }

    public synchronized boolean isEmpty() {
        this.load();
        return this.indexList.isEmpty();
    }

    public synchronized boolean contains(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            IndexItem next = this.indexList.getFirst();
            while (next != null) {
                Object value = this.getValue(next);
                if (value != null && value.equals(o)) {
                    result = true;
                    break;
                }
                next = this.indexList.getNextEntry(next);
            }
        }
        return result;
    }

    public synchronized Iterator iterator() {
        this.load();
        return this.listIterator();
    }

    public synchronized Object[] toArray() {
        this.load();
        ArrayList<Object> tmp = new ArrayList<Object>(this.indexList.size());
        IndexItem next = this.indexList.getFirst();
        while (next != null) {
            Object value = this.getValue(next);
            tmp.add(value);
            next = this.indexList.getNextEntry(next);
        }
        return tmp.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        this.load();
        ArrayList<Object> tmp = new ArrayList<Object>(this.indexList.size());
        IndexItem next = this.indexList.getFirst();
        while (next != null) {
            Object value = this.getValue(next);
            tmp.add(value);
            next = this.indexList.getNextEntry(next);
        }
        return tmp.toArray(a);
    }

    public synchronized boolean add(Object o) {
        this.load();
        this.addLast(o);
        return true;
    }

    public synchronized boolean remove(Object o) {
        this.load();
        boolean result = false;
        int pos = 0;
        IndexItem next = this.indexList.getFirst();
        while (next != null) {
            Object value = this.getValue(next);
            if (value != null && value.equals(o)) {
                this.remove(next);
                this.itemRemoved(pos);
                result = true;
                break;
            }
            next = this.indexList.getNextEntry(next);
            ++pos;
        }
        return result;
    }

    protected void remove(IndexItem item) {
        IndexItem prev = this.indexList.getPrevEntry(item);
        IndexItem next = this.indexList.getNextEntry(item);
        this.indexList.remove(item);
        this.delete(item, prev, next);
    }

    public synchronized boolean containsAll(Collection c) {
        this.load();
        boolean result = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            result = this.contains(obj);
            if (result) continue;
            result = false;
            break;
        }
        return result;
    }

    public synchronized boolean addAll(Collection c) {
        this.load();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
        return true;
    }

    public synchronized boolean addAll(int index, Collection c) {
        this.load();
        boolean result = false;
        ListIterator e1 = this.listIterator(index);
        Iterator e2 = c.iterator();
        while (e2.hasNext()) {
            e1.add(e2.next());
            result = true;
        }
        return result;
    }

    public synchronized boolean removeAll(Collection c) {
        this.load();
        boolean result = true;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            result &= this.remove(obj);
        }
        return result;
    }

    public synchronized boolean retainAll(Collection c) {
        this.load();
        ArrayList<Object> tmpList = new ArrayList<Object>();
        IndexItem next = this.indexList.getFirst();
        while (next != null) {
            Object o = this.getValue(next);
            if (!c.contains(o)) {
                tmpList.add(o);
            }
            next = this.indexList.getNextEntry(next);
        }
        Iterator i = tmpList.iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
        return !tmpList.isEmpty();
    }

    public synchronized void clear() {
        this.checkClosed();
        super.clear();
        this.doClear();
        this.clearCache();
    }

    public synchronized Object get(int index) {
        this.load();
        return this.getCachedItem(index);
    }

    public Object set(int index, Object element) {
        this.load();
        Object result = null;
        IndexItem replace = this.indexList.isEmpty() ? null : this.indexList.get(index);
        IndexItem prev = this.indexList.isEmpty() || index - 1 < 0 ? null : this.indexList.get(index - 1);
        IndexItem next = this.indexList.isEmpty() || index + 1 >= this.size() ? null : this.indexList.get(index + 1);
        result = this.getValue(replace);
        this.indexList.remove(index);
        this.delete(replace, prev, next);
        this.itemRemoved(index);
        this.add(index, element);
        return result;
    }

    protected IndexItem internalSet(int index, Object element) {
        IndexItem replace = this.indexList.isEmpty() ? null : this.indexList.get(index);
        IndexItem prev = this.indexList.isEmpty() || index - 1 < 0 ? null : this.indexList.get(index - 1);
        IndexItem next = this.indexList.isEmpty() || index + 1 >= this.size() ? null : this.indexList.get(index + 1);
        this.indexList.remove(index);
        this.delete(replace, prev, next);
        this.itemRemoved(index);
        return this.internalAdd(index, element);
    }

    public synchronized void add(int index, Object element) {
        this.load();
        IndexItem item = this.insert(index, element);
        this.indexList.add(index, item);
        this.itemAdded(item, index, element);
    }

    protected StoreEntry internalAddLast(Object o) {
        this.load();
        IndexItem item = this.writeLast(o);
        this.indexList.addLast(item);
        this.itemAdded(item, this.indexList.size() - 1, o);
        return item;
    }

    protected StoreEntry internalAddFirst(Object o) {
        this.load();
        IndexItem item = this.writeFirst(o);
        this.indexList.addFirst(item);
        this.itemAdded(item, 0, o);
        return item;
    }

    protected IndexItem internalAdd(int index, Object element) {
        this.load();
        IndexItem item = this.insert(index, element);
        this.indexList.add(index, item);
        this.itemAdded(item, index, element);
        return item;
    }

    protected StoreEntry internalGet(int index) {
        this.load();
        if (index >= 0 && index < this.indexList.size()) {
            return this.indexList.get(index);
        }
        return null;
    }

    public synchronized boolean doRemove(int index) {
        this.load();
        boolean result = false;
        IndexItem item = this.indexList.get(index);
        if (item != null) {
            result = true;
            IndexItem prev = this.indexList.getPrevEntry(item);
            prev = prev != null ? prev : this.root;
            IndexItem next = this.indexList.getNextEntry(prev);
            this.indexList.remove(index);
            this.itemRemoved(index);
            this.delete(item, prev, next);
        }
        return result;
    }

    public synchronized Object remove(int index) {
        this.load();
        Object result = null;
        IndexItem item = this.indexList.get(index);
        if (item != null) {
            this.itemRemoved(index);
            result = this.getValue(item);
            IndexItem prev = this.indexList.getPrevEntry(item);
            prev = prev != null ? prev : this.root;
            IndexItem next = this.indexList.getNextEntry(item);
            this.indexList.remove(index);
            this.delete(item, prev, next);
        }
        return result;
    }

    public synchronized int indexOf(Object o) {
        this.load();
        int result = -1;
        if (o != null) {
            int count = 0;
            IndexItem next = this.indexList.getFirst();
            while (next != null) {
                Object value = this.getValue(next);
                if (value != null && value.equals(o)) {
                    result = count;
                    break;
                }
                ++count;
                next = this.indexList.getNextEntry(next);
            }
        }
        return result;
    }

    public synchronized int lastIndexOf(Object o) {
        this.load();
        int result = -1;
        if (o != null) {
            int count = this.indexList.size() - 1;
            IndexItem next = this.indexList.getLast();
            while (next != null) {
                Object value = this.getValue(next);
                if (value != null && value.equals(o)) {
                    result = count;
                    break;
                }
                --count;
                next = this.indexList.getPrevEntry(next);
            }
        }
        return result;
    }

    public synchronized ListIterator listIterator() {
        this.load();
        return new CachedContainerListIterator(this, 0);
    }

    public synchronized ListIterator listIterator(int index) {
        this.load();
        return new CachedContainerListIterator(this, index);
    }

    public synchronized List subList(int fromIndex, int toIndex) {
        this.load();
        ArrayList<Object> result = new ArrayList<Object>();
        int count = fromIndex;
        IndexItem next = this.indexList.get(fromIndex);
        while (next != null && count++ < toIndex) {
            result.add(this.getValue(next));
            next = this.indexList.getNextEntry(next);
        }
        return result;
    }

    public synchronized StoreEntry placeLast(Object object) {
        StoreEntry item = this.internalAddLast(object);
        return item;
    }

    public synchronized StoreEntry placeFirst(Object object) {
        StoreEntry item = this.internalAddFirst(object);
        return item;
    }

    public void update(StoreEntry entry, Object object) {
        try {
            this.dataManager.updateItem(entry.getValueDataItem(), this.marshaller, object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Object get(StoreEntry entry) {
        this.load();
        return this.getValue(entry);
    }

    public synchronized boolean remove(StoreEntry entry) {
        IndexItem item = (IndexItem)entry;
        this.load();
        boolean result = false;
        if (item != null) {
            this.clearCache();
            this.remove(item);
            result = true;
        }
        return result;
    }

    public synchronized StoreEntry getFirst() {
        return this.indexList.getFirst();
    }

    public synchronized StoreEntry getLast() {
        return this.indexList.getLast();
    }

    public synchronized StoreEntry getNext(StoreEntry entry) {
        IndexItem item = (IndexItem)entry;
        return this.indexList.getNextEntry(item);
    }

    public synchronized StoreEntry getPrevious(StoreEntry entry) {
        IndexItem item = (IndexItem)entry;
        return this.indexList.getPrevEntry(item);
    }

    public synchronized StoreEntry refresh(StoreEntry entry) {
        return this.indexList.getEntry(entry);
    }

    protected IndexItem writeLast(Object value) {
        IndexItem index = null;
        try {
            if (value != null) {
                StoreLocation data = this.dataManager.storeDataItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = this.indexList.getLast();
                prev = prev != null ? prev : this.root;
                IndexItem next = this.indexList.getNextEntry(prev);
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.updateIndexes(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.updateIndexes(next);
                }
                this.storeIndex(index);
            }
        }
        catch (IOException e) {
            log.error("Failed to write " + value, e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    protected IndexItem writeFirst(Object value) {
        IndexItem index = null;
        try {
            if (value != null) {
                StoreLocation data = this.dataManager.storeDataItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = this.root;
                IndexItem next = this.indexList.getNextEntry(prev);
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.updateIndexes(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.updateIndexes(next);
                }
                this.storeIndex(index);
            }
        }
        catch (IOException e) {
            log.error("Failed to write " + value, e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    protected IndexItem insert(int insertPos, Object value) {
        IndexItem index = null;
        try {
            if (value != null) {
                StoreLocation data = this.dataManager.storeDataItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = null;
                IndexItem next = null;
                if (insertPos <= 0) {
                    prev = this.root;
                    next = this.indexList.getNextEntry(this.root);
                } else if (insertPos >= this.indexList.size()) {
                    prev = this.indexList.getLast();
                    next = null;
                } else {
                    prev = this.indexList.get(insertPos);
                    prev = prev != null ? prev : this.root;
                    next = this.indexList.getNextEntry(prev);
                }
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.updateIndexes(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.updateIndexes(next);
                }
                this.storeIndex(index);
            }
        }
        catch (IOException e) {
            log.error("Failed to insert " + value, e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    protected Object getValue(StoreEntry item) {
        Object result = null;
        if (item != null) {
            try {
                StoreLocation data = item.getValueDataItem();
                result = this.dataManager.readItem(this.marshaller, data);
            }
            catch (IOException e) {
                log.error("Failed to get value for " + item, e);
                throw new RuntimeStoreException(e);
            }
        }
        return result;
    }

    public synchronized String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        Iterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            result.append(String.valueOf(o));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    protected void itemAdded(IndexItem item, int pos, Object value) {
        int cachePosition = pos - this.offset;
        if (pos < this.offset) {
            this.clearCache();
        }
        if (this.cacheList.isEmpty()) {
            this.offset = pos;
            this.cacheList.add(value);
            this.lastCached = item;
        } else if (cachePosition == this.cacheList.size() && cachePosition < this.maximumCacheSize) {
            this.cacheList.add(value);
            this.lastCached = item;
        } else if (cachePosition >= 0 && cachePosition <= this.cacheList.size()) {
            this.cacheList.add(cachePosition, value);
            if (this.cacheList.size() > this.maximumCacheSize) {
                this.itemRemoved(this.cacheList.size() - 1);
            }
        }
    }

    protected void itemRemoved(int pos) {
        int lastPosition = this.offset + this.cacheList.size() - 1;
        int cachePosition = pos - this.offset;
        if (cachePosition >= 0 && cachePosition < this.cacheList.size()) {
            if (cachePosition == lastPosition && this.lastCached != null) {
                this.lastCached = this.indexList.getPrevEntry(this.lastCached);
            }
            this.cacheList.remove(pos);
            if (this.cacheList.isEmpty()) {
                this.clearCache();
            }
        }
    }

    protected Object getCachedItem(int pos) {
        int cachePosition = pos - this.offset;
        Object result = null;
        if (cachePosition >= 0 && cachePosition < this.cacheList.size()) {
            result = this.cacheList.get(cachePosition);
        }
        if (result == null) {
            if (cachePosition == this.cacheList.size() && this.lastCached != null) {
                IndexItem item = this.indexList.getNextEntry(this.lastCached);
                if (item != null) {
                    result = this.getValue(item);
                    this.cacheList.add(result);
                    this.lastCached = item;
                    if (this.cacheList.size() > this.maximumCacheSize) {
                        this.itemRemoved(0);
                    }
                }
            } else {
                IndexItem item = this.indexList.get(pos);
                if (item != null && (result = this.getValue(item)) != null) {
                    if (!this.cacheList.isEmpty()) {
                        this.clearCache();
                    }
                    this.offset = pos;
                    this.cacheList.add(result);
                    this.lastCached = item;
                }
            }
        }
        return result;
    }

    public synchronized void clearCache() {
        this.cacheList.clear();
        this.offset = 0;
        this.lastCached = null;
    }

    public synchronized LinkedList getCacheList() {
        return this.cacheList;
    }

    public synchronized void setCacheList(LinkedList cacheList) {
        this.cacheList = cacheList;
    }

    public synchronized StoreEntry getLastCached() {
        return this.lastCached;
    }

    public synchronized void setLastCached(IndexItem lastCached) {
        this.lastCached = lastCached;
    }

    public synchronized int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public synchronized void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized void setOffset(int offset) {
        this.offset = offset;
    }
}

