/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.container.BaseContainerImpl;
import org.apache.activemq.kaha.impl.container.ContainerEntrySet;
import org.apache.activemq.kaha.impl.container.ContainerId;
import org.apache.activemq.kaha.impl.container.ContainerKeySet;
import org.apache.activemq.kaha.impl.container.ContainerValueCollection;
import org.apache.activemq.kaha.impl.data.DataManager;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MapContainerImpl
extends BaseContainerImpl
implements MapContainer {
    private static final Log log = LogFactory.getLog(MapContainerImpl.class);
    protected Map indexMap;
    protected Marshaller keyMarshaller = Store.ObjectMarshaller;
    protected Marshaller valueMarshaller = Store.ObjectMarshaller;

    public MapContainerImpl(ContainerId id, IndexItem root, IndexManager indexManager, DataManager dataManager, String indexType) {
        super(id, root, indexManager, dataManager, indexType);
    }

    public synchronized void init() {
        super.init();
        if (this.indexMap == null) {
            this.indexMap = this.indexType.equals("DiskIndex") ? new HashMap() : new HashMap();
        }
    }

    public synchronized void load() {
        this.checkClosed();
        if (!this.loaded && !this.loaded) {
            this.loaded = true;
            try {
                this.init();
                long nextItem = this.root.getNextItem();
                while (nextItem != -1L) {
                    IndexItem item = this.indexManager.getIndex(nextItem);
                    StoreLocation data = item.getKeyDataItem();
                    Object key = this.dataManager.readItem(this.keyMarshaller, data);
                    this.indexMap.put(key, item);
                    this.indexList.add(item);
                    nextItem = item.getNextItem();
                }
            }
            catch (IOException e) {
                log.error("Failed to load container " + this.getId(), e);
                throw new RuntimeStoreException(e);
            }
        }
    }

    public synchronized void unload() {
        this.checkClosed();
        if (this.loaded) {
            this.loaded = false;
            this.indexMap.clear();
            this.indexList.clear();
        }
    }

    public synchronized void setKeyMarshaller(Marshaller keyMarshaller) {
        this.checkClosed();
        this.keyMarshaller = keyMarshaller;
    }

    public synchronized void setValueMarshaller(Marshaller valueMarshaller) {
        this.checkClosed();
        this.valueMarshaller = valueMarshaller;
    }

    public synchronized int size() {
        this.load();
        return this.indexMap.size();
    }

    public synchronized boolean isEmpty() {
        this.load();
        return this.indexMap.isEmpty();
    }

    public synchronized boolean containsKey(Object key) {
        this.load();
        return this.indexMap.containsKey(key);
    }

    public synchronized Object get(Object key) {
        this.load();
        Object result = null;
        StoreEntry item = null;
        item = (StoreEntry)this.indexMap.get(key);
        if (item != null) {
            result = this.getValue(item);
        }
        return result;
    }

    public synchronized boolean containsValue(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            IndexItem item = this.indexList.getFirst();
            while (item != null) {
                Object value = this.getValue(item);
                if (value != null && value.equals(o)) {
                    result = true;
                    break;
                }
                item = this.indexList.getNextEntry(item);
            }
        }
        return result;
    }

    public synchronized void putAll(Map t) {
        this.load();
        if (t != null) {
            Iterator i = t.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized Set keySet() {
        this.load();
        return new ContainerKeySet(this);
    }

    public synchronized Collection values() {
        this.load();
        return new ContainerValueCollection(this);
    }

    public synchronized Set entrySet() {
        this.load();
        return new ContainerEntrySet(this);
    }

    public synchronized Object put(Object key, Object value) {
        this.load();
        Object result = this.remove(key);
        IndexItem item = this.write(key, value);
        this.indexMap.put(key, item);
        this.indexList.add(item);
        return result;
    }

    public synchronized Object remove(Object key) {
        this.load();
        Object result = null;
        IndexItem item = (IndexItem)this.indexMap.get(key);
        if (item != null) {
            item = (IndexItem)this.indexList.refreshEntry(item);
            this.indexMap.remove(key);
            result = this.getValue(item);
            IndexItem prev = this.indexList.getPrevEntry(item);
            IndexItem next = this.indexList.getNextEntry(item);
            this.indexList.remove(item);
            this.delete(item, prev, next);
        }
        return result;
    }

    public synchronized boolean removeValue(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            IndexItem item = this.indexList.getFirst();
            while (item != null) {
                Object value = this.getValue(item);
                if (value != null && value.equals(o)) {
                    result = true;
                    Object key = this.getKey(item);
                    if (key == null) break;
                    this.remove(key);
                    break;
                }
                item = this.indexList.getNextEntry(item);
            }
        }
        return result;
    }

    protected void remove(IndexItem item) {
        Object key = this.getKey(item);
        if (key != null) {
            this.remove(key);
        }
    }

    public synchronized void clear() {
        this.checkClosed();
        this.loaded = true;
        if (this.indexMap != null) {
            this.indexMap.clear();
        }
        super.clear();
        this.doClear();
    }

    public StoreEntry place(Object key, Object value) {
        this.load();
        if (this.indexMap.containsKey(key)) {
            this.remove(key);
        }
        IndexItem item = this.write(key, value);
        this.indexMap.put(key, item);
        this.indexList.add(item);
        return item;
    }

    public void remove(StoreEntry entry) {
        this.load();
        IndexItem item = (IndexItem)entry;
        if (item != null) {
            Object key = this.getKey(item);
            this.indexMap.remove(key);
            IndexItem prev = this.indexList.getPrevEntry(item);
            IndexItem next = this.indexList.getNextEntry(item);
            this.indexList.remove(item);
            this.delete(item, prev, next);
        }
    }

    public synchronized Object getValue(StoreEntry item) {
        this.load();
        Object result = null;
        if (item != null) {
            try {
                StoreLocation data = item.getValueDataItem();
                result = this.dataManager.readItem(this.valueMarshaller, data);
            }
            catch (IOException e) {
                log.error("Failed to get value for " + item, e);
                throw new RuntimeStoreException(e);
            }
        }
        return result;
    }

    public synchronized Object getKey(StoreEntry item) {
        this.load();
        Object result = null;
        if (item != null) {
            try {
                StoreLocation data = item.getKeyDataItem();
                result = this.dataManager.readItem(this.keyMarshaller, data);
            }
            catch (IOException e) {
                log.error("Failed to get key for " + item, e);
                throw new RuntimeStoreException(e);
            }
        }
        return result;
    }

    protected Set getInternalKeySet() {
        return new HashSet(this.indexMap.keySet());
    }

    protected IndexLinkedList getItemList() {
        return this.indexList;
    }

    protected IndexItem write(Object key, Object value) {
        IndexItem index = null;
        try {
            IndexItem prev;
            StoreLocation data;
            if (key != null) {
                index = this.indexManager.createNewIndex();
                data = this.dataManager.storeDataItem(this.keyMarshaller, key);
                index.setKeyData(data);
            }
            if (value != null) {
                data = this.dataManager.storeDataItem(this.valueMarshaller, value);
                index.setValueData(data);
            }
            prev = (prev = this.indexList.getLast()) != null ? prev : this.indexList.getRoot();
            IndexItem next = this.indexList.getNextEntry(prev);
            prev.setNextItem(index.getOffset());
            index.setPreviousItem(prev.getOffset());
            this.updateIndexes(prev);
            if (next != null) {
                next.setPreviousItem(index.getOffset());
                index.setNextItem(next.getOffset());
                this.updateIndexes(next);
            }
            this.storeIndex(index);
        }
        catch (IOException e) {
            log.error("Failed to write " + key + " , " + value, e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    public Map getIndexMap() {
        return this.indexMap;
    }

    public void setIndexMap(Map map) {
        this.indexMap = map;
    }
}

