/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.memory;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.activemq.memory.UsageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UsageManager {
    private static final Log log = LogFactory.getLog(UsageManager.class);
    private final UsageManager parent;
    private long limit;
    private long usage;
    private int percentUsage;
    private int percentUsageMinDelta = 1;
    private final Object usageMutex = new Object();
    private final CopyOnWriteArrayList listeners = new CopyOnWriteArrayList();
    private final LinkedList callbacks = new LinkedList();
    private boolean sendFailIfNoSpace;
    private boolean sendFailIfNoSpaceExplicitySet;

    public UsageManager() {
        this(null);
    }

    public UsageManager(UsageManager parent) {
        this.parent = parent;
    }

    public void enqueueUsage(long value) throws InterruptedException {
        this.waitForSpace();
        this.increaseUsage(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSpace() throws InterruptedException {
        if (this.parent != null) {
            this.parent.waitForSpace();
        }
        Object object = this.usageMutex;
        synchronized (object) {
            int i = 0;
            while (this.percentUsage >= 100) {
                this.usageMutex.wait();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSpace(long timeout) throws InterruptedException {
        if (this.parent != null && !this.parent.waitForSpace(timeout)) {
            return false;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            if (this.percentUsage >= 100) {
                this.usageMutex.wait(timeout);
            }
            return this.percentUsage < 100;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyCallbackWhenNotFull(final Runnable callback) {
        Runnable r;
        if (this.parent != null && this.parent.notifyCallbackWhenNotFull(r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = UsageManager.this.usageMutex;
                synchronized (object) {
                    if (UsageManager.this.percentUsage >= 100) {
                        UsageManager.this.callbacks.add(callback);
                    } else {
                        callback.run();
                    }
                }
            }
        })) {
            return true;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            if (this.percentUsage >= 100) {
                this.callbacks.add(callback);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseUsage(long value) {
        int percentUsage;
        if (value == 0L) {
            return;
        }
        if (this.parent != null) {
            this.parent.increaseUsage(value);
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.usage += value;
            percentUsage = this.caclPercentUsage();
        }
        this.setPercentUsage(percentUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseUsage(long value) {
        int percentUsage;
        if (value == 0L) {
            return;
        }
        if (this.parent != null) {
            this.parent.decreaseUsage(value);
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.usage -= value;
            percentUsage = this.caclPercentUsage();
        }
        this.setPercentUsage(percentUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        if (this.parent != null && this.parent.isFull()) {
            return true;
        }
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsage >= 100;
        }
    }

    public void addUsageListener(UsageListener listener) {
        this.listeners.add(listener);
    }

    public void removeUsageListener(UsageListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLimit() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(long limit) {
        int percentUsage;
        if (this.percentUsageMinDelta < 0) {
            throw new IllegalArgumentException("percentUsageMinDelta must be greater or equal to 0");
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.limit = limit;
            percentUsage = this.caclPercentUsage();
        }
        this.setPercentUsage(percentUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercentUsage() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercentUsageMinDelta() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsageMinDelta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPercentUsageMinDelta(int percentUsageMinDelta) {
        int percentUsage;
        if (percentUsageMinDelta < 1) {
            throw new IllegalArgumentException("percentUsageMinDelta must be greater than 0");
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.percentUsageMinDelta = percentUsageMinDelta;
            percentUsage = this.caclPercentUsage();
        }
        this.setPercentUsage(percentUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsage() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.usage;
        }
    }

    public void setSendFailIfNoSpace(boolean failProducerIfNoSpace) {
        this.sendFailIfNoSpaceExplicitySet = true;
        this.sendFailIfNoSpace = failProducerIfNoSpace;
    }

    public boolean isSendFailIfNoSpace() {
        if (this.sendFailIfNoSpaceExplicitySet || this.parent == null) {
            return this.sendFailIfNoSpace;
        }
        return this.parent.isSendFailIfNoSpace();
    }

    private void setPercentUsage(int value) {
        int oldValue = this.percentUsage;
        this.percentUsage = value;
        if (oldValue != value) {
            this.fireEvent(oldValue, value);
        }
    }

    private int caclPercentUsage() {
        if (this.limit == 0L) {
            return 0;
        }
        return (int)(this.usage * 100L / this.limit / (long)this.percentUsageMinDelta * (long)this.percentUsageMinDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(int oldPercentUsage, int newPercentUsage) {
        log.debug("Memory usage change.  from: " + oldPercentUsage + ", to: " + newPercentUsage);
        if (oldPercentUsage >= 100 && newPercentUsage < 100) {
            Object object = this.usageMutex;
            synchronized (object) {
                this.usageMutex.notifyAll();
                Iterator iter = this.callbacks.iterator();
                while (iter.hasNext()) {
                    Runnable callback = (Runnable)iter.next();
                    callback.run();
                }
                this.callbacks.clear();
            }
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            UsageListener l = (UsageListener)iter.next();
            l.onMemoryUseChanged(this, oldPercentUsage, newPercentUsage);
        }
    }

    public String toString() {
        return "UsageManager: percentUsage=" + this.percentUsage + "%, usage=" + this.usage + " limit=" + this.limit + " percentUsageMinDelta=" + this.percentUsageMinDelta + "%";
    }
}

