/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.network.Bridge;
import org.apache.activemq.network.ConduitBridge;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DurableConduitBridge;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;

public class DiscoveryNetworkConnector
extends NetworkConnector
implements DiscoveryListener {
    private DiscoveryAgent discoveryAgent;
    private ConcurrentHashMap bridges = new ConcurrentHashMap();

    public DiscoveryNetworkConnector() {
    }

    public DiscoveryNetworkConnector(URI discoveryURI) throws IOException {
        this.setUri(discoveryURI);
    }

    public void setUri(URI discoveryURI) throws IOException {
        this.setDiscoveryAgent(DiscoveryAgentFactory.createDiscoveryAgent(discoveryURI));
    }

    public void onServiceAdd(DiscoveryEvent event) {
        if (this.isStopped() || this.isStopping()) {
            return;
        }
        String url = event.getServiceName();
        if (url != null) {
            Transport localTransport;
            Transport remoteTransport;
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                log.warn("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e, e);
                return;
            }
            if (this.bridges.containsKey(uri) || this.localURI.equals(uri) || this.connectionFilter != null && !this.connectionFilter.connectTo(uri)) {
                return;
            }
            URI connectUri = uri;
            if (this.failover) {
                try {
                    connectUri = new URI("failover:(" + connectUri + ")?maxReconnectDelay=1000");
                }
                catch (URISyntaxException e) {
                    log.warn("Could not create failover URI: " + connectUri);
                    return;
                }
            }
            log.info("Establishing network connection between from " + this.localURI + " to " + connectUri);
            try {
                remoteTransport = TransportFactory.connect(connectUri);
            }
            catch (Exception e) {
                log.warn("Could not connect to remote URI: " + this.localURI + ": " + e.getMessage());
                log.debug("Connection failure exception: " + e, e);
                return;
            }
            try {
                localTransport = this.createLocalTransport();
            }
            catch (Exception e) {
                ServiceSupport.dispose(remoteTransport);
                log.warn("Could not connect to local URI: " + this.localURI + ": " + e.getMessage());
                log.debug("Connection failure exception: " + e, e);
                return;
            }
            Bridge bridge = this.createBridge(localTransport, remoteTransport, event);
            this.bridges.put(uri, bridge);
            try {
                bridge.start();
            }
            catch (Exception e) {
                ServiceSupport.dispose(localTransport);
                ServiceSupport.dispose(remoteTransport);
                log.warn("Could not start network bridge between: " + this.localURI + " and: " + uri + " due to: " + e);
                log.debug("Start failure exception: " + e, e);
                try {
                    this.discoveryAgent.serviceFailed(event);
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public void onServiceRemove(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                log.warn("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e, e);
                return;
            }
            Bridge bridge = (Bridge)this.bridges.remove(uri);
            if (bridge == null) {
                return;
            }
            ServiceSupport.dispose(bridge);
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
        if (discoveryAgent != null) {
            this.discoveryAgent.setDiscoveryListener(this);
            this.discoveryAgent.setBrokerName(this.getBrokerName());
        }
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean reliable) {
        this.failover = reliable;
    }

    protected void doStart() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("You must configure the 'discoveryAgent' property");
        }
        this.discoveryAgent.start();
        super.doStart();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        Iterator i = this.bridges.values().iterator();
        while (i.hasNext()) {
            Bridge bridge = (Bridge)i.next();
            try {
                bridge.stop();
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
        try {
            this.discoveryAgent.stop();
        }
        catch (Exception e) {
            stopper.onException(this, e);
        }
        super.doStop(stopper);
    }

    protected Bridge createBridge(Transport localTransport, Transport remoteTransport, final DiscoveryEvent event) {
        DemandForwardingBridge result = null;
        result = this.conduitSubscriptions ? (this.dynamicOnly ? new ConduitBridge(localTransport, remoteTransport){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void serviceLocalException(Throwable error) {
                try {
                    super.serviceLocalException(error);
                }
                finally {
                    this.fireServiceFailed();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void serviceRemoteException(Throwable error) {
                try {
                    super.serviceRemoteException(error);
                }
                finally {
                    this.fireServiceFailed();
                }
            }

            public void fireServiceFailed() {
                if (!DiscoveryNetworkConnector.this.isStopped()) {
                    try {
                        DiscoveryNetworkConnector.this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        } : new DurableConduitBridge(localTransport, remoteTransport){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void serviceLocalException(Throwable error) {
                try {
                    super.serviceLocalException(error);
                }
                finally {
                    this.fireServiceFailed();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void serviceRemoteException(Throwable error) {
                try {
                    super.serviceRemoteException(error);
                }
                finally {
                    this.fireServiceFailed();
                }
            }

            public void fireServiceFailed() {
                if (!DiscoveryNetworkConnector.this.isStopped()) {
                    try {
                        DiscoveryNetworkConnector.this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }) : new DemandForwardingBridge(localTransport, remoteTransport){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void serviceLocalException(Throwable error) {
                try {
                    super.serviceLocalException(error);
                }
                finally {
                    this.fireServiceFailed();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void serviceRemoteException(Throwable error) {
                try {
                    super.serviceRemoteException(error);
                }
                finally {
                    this.fireServiceFailed();
                }
            }

            public void fireServiceFailed() {
                if (!DiscoveryNetworkConnector.this.isStopped()) {
                    try {
                        DiscoveryNetworkConnector.this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        return this.configureBridge(result);
    }

    protected String createName() {
        return this.discoveryAgent.toString();
    }
}

