/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.proxy;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import org.apache.activemq.Service;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ProxyConnection
implements Service {
    private static final Log log = LogFactory.getLog(ProxyConnection.class);
    private final Transport localTransport;
    private final Transport remoteTransport;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private AtomicBoolean running = new AtomicBoolean(false);
    static /* synthetic */ Class class$org$apache$activemq$command$ShutdownInfo;

    public ProxyConnection(Transport localTransport, Transport remoteTransport) {
        this.localTransport = localTransport;
        this.remoteTransport = remoteTransport;
    }

    public void onFailure(IOException e) {
        if (!this.shuttingDown.get()) {
            log.debug("Transport error: " + e, e);
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void start() throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.localTransport.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object command) {
                boolean shutdown = false;
                if (command.getClass() == (class$org$apache$activemq$command$ShutdownInfo == null ? (class$org$apache$activemq$command$ShutdownInfo = ProxyConnection.class$("org.apache.activemq.command.ShutdownInfo")) : class$org$apache$activemq$command$ShutdownInfo)) {
                    ProxyConnection.this.shuttingDown.set(true);
                    shutdown = true;
                }
                try {
                    ProxyConnection.this.remoteTransport.oneway(command);
                    if (shutdown) {
                        ProxyConnection.this.stop();
                    }
                }
                catch (IOException error) {
                    ProxyConnection.this.onFailure(error);
                }
                catch (Exception error) {
                    ProxyConnection.this.onFailure(IOExceptionSupport.create(error));
                }
            }

            public void onException(IOException error) {
                ProxyConnection.this.onFailure(error);
            }
        });
        this.remoteTransport.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object command) {
                try {
                    ProxyConnection.this.localTransport.oneway(command);
                }
                catch (IOException error) {
                    ProxyConnection.this.onFailure(error);
                }
            }

            public void onException(IOException error) {
                ProxyConnection.this.onFailure(error);
            }
        });
        this.localTransport.start();
        this.remoteTransport.start();
    }

    public void stop() throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        this.shuttingDown.set(true);
        ServiceStopper ss = new ServiceStopper();
        ss.stop(this.localTransport);
        ss.stop(this.remoteTransport);
        ss.throwFirstException();
    }
}

