/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.state;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Collection;
import java.util.Set;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.ProducerState;

public class SessionState {
    final SessionInfo info;
    public final ConcurrentHashMap producers = new ConcurrentHashMap();
    public final ConcurrentHashMap consumers = new ConcurrentHashMap();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public SessionState(SessionInfo info) {
        this.info = info;
    }

    public String toString() {
        return this.info.toString();
    }

    public void addProducer(ProducerInfo info) {
        this.checkShutdown();
        this.producers.put(info.getProducerId(), new ProducerState(info));
    }

    public ProducerState removeProducer(ProducerId id) {
        return (ProducerState)this.producers.remove(id);
    }

    public void addConsumer(ConsumerInfo info) {
        this.checkShutdown();
        this.consumers.put(info.getConsumerId(), new ConsumerState(info));
    }

    public ConsumerState removeConsumer(ConsumerId id) {
        return (ConsumerState)this.consumers.remove(id);
    }

    public SessionInfo getInfo() {
        return this.info;
    }

    public Set getConsumerIds() {
        return this.consumers.keySet();
    }

    public Set getProducerIds() {
        return this.producers.keySet();
    }

    public Collection getProducerStates() {
        return this.producers.values();
    }

    public ProducerState getProducerState(ProducerId producerId) {
        return (ProducerState)this.producers.get(producerId);
    }

    public Collection getConsumerStates() {
        return this.consumers.values();
    }

    private void checkShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Disposed");
        }
    }

    public void shutdown() {
        this.shutdown.set(false);
    }
}

