/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.IOException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;

public class ProxyMessageStore
implements MessageStore {
    final MessageStore delegate;

    public ProxyMessageStore(MessageStore delegate) {
        this.delegate = delegate;
    }

    public MessageStore getDelegate() {
        return this.delegate;
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        this.delegate.addMessage(context, message);
    }

    public Message getMessage(MessageId identity) throws IOException {
        return this.delegate.getMessage(identity);
    }

    public void recover(MessageRecoveryListener listener) throws Exception {
        this.delegate.recover(listener);
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.delegate.removeAllMessages(context);
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.delegate.removeMessage(context, ack);
    }

    public void start() throws Exception {
        this.delegate.start();
    }

    public void stop() throws Exception {
        this.delegate.stop();
    }

    public ActiveMQDestination getDestination() {
        return this.delegate.getDestination();
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        this.delegate.addMessageReference(context, messageId, expirationTime, messageRef);
    }

    public String getMessageReference(MessageId identity) throws IOException {
        return this.delegate.getMessageReference(identity);
    }

    public void setUsageManager(UsageManager usageManager) {
        this.delegate.setUsageManager(usageManager);
    }
}

