/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.command.Command;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VMTransport
implements Transport,
Task {
    private static final Log log = LogFactory.getLog(VMTransport.class);
    private static final AtomicLong nextId = new AtomicLong(0L);
    private static final TaskRunnerFactory taskRunnerFactory = new TaskRunnerFactory("VMTransport", 5, true, 1000);
    protected VMTransport peer;
    protected TransportListener transportListener;
    protected boolean disposed;
    protected boolean marshal;
    protected boolean network;
    protected boolean async = false;
    protected boolean started = false;
    protected int asyncQueueDepth = 2000;
    protected List prePeerSetQueue = Collections.synchronizedList(new LinkedList());
    protected LinkedBlockingQueue messageQueue;
    protected final URI location;
    protected final long id;
    private TaskRunner taskRunner;

    public VMTransport(URI location) {
        this.location = location;
        this.id = nextId.getAndIncrement();
    }

    public synchronized VMTransport getPeer() {
        return this.peer;
    }

    public synchronized void setPeer(VMTransport peer) {
        this.peer = peer;
    }

    public void oneway(Object command) throws IOException {
        if (this.disposed) {
            throw new TransportDisposedIOException("Transport disposed.");
        }
        if (this.peer == null) {
            throw new IOException("Peer not connected.");
        }
        if (!this.peer.disposed) {
            if (this.async) {
                this.asyncOneWay(command);
            } else {
                this.syncOneWay(command);
            }
        } else {
            throw new TransportDisposedIOException("Peer (" + this.peer.toString() + ") disposed.");
        }
    }

    protected void syncOneWay(Object command) {
        TransportListener tl = this.peer.transportListener;
        this.prePeerSetQueue = this.peer.prePeerSetQueue;
        if (tl == null) {
            this.prePeerSetQueue.add(command);
        } else {
            tl.onCommand(command);
        }
    }

    protected void asyncOneWay(Object command) throws IOException {
        this.messageQueue = this.getMessageQueue();
        try {
            this.messageQueue.put(command);
            this.wakeup();
        }
        catch (InterruptedException e) {
            log.error("messageQueue interupted", e);
            throw new IOException(e.getMessage());
        }
    }

    public FutureResponse asyncRequest(Object command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Object request(Object command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Object request(Object command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public synchronized TransportListener getTransportListener() {
        return this.transportListener;
    }

    public synchronized void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
        this.wakeup();
        this.peer.wakeup();
    }

    public synchronized void start() throws Exception {
        this.started = true;
        if (this.transportListener == null) {
            throw new IOException("TransportListener not set.");
        }
        if (!this.async) {
            Iterator iter = this.prePeerSetQueue.iterator();
            while (iter.hasNext()) {
                Command command = (Command)iter.next();
                this.transportListener.onCommand(command);
                iter.remove();
            }
        } else {
            this.wakeup();
            this.peer.wakeup();
        }
    }

    public void stop() throws Exception {
        this.started = false;
        if (!this.disposed) {
            this.disposed = true;
        }
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
            this.taskRunner = null;
        }
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    public boolean isNetwork() {
        return this.network;
    }

    public void setNetwork(boolean network) {
        this.network = network;
    }

    public String toString() {
        return this.location + "#" + this.id;
    }

    public String getRemoteAddress() {
        if (this.peer != null) {
            return this.peer.toString();
        }
        return null;
    }

    public boolean iterate() {
        TransportListener tl = this.peer.transportListener;
        if (!this.messageQueue.isEmpty() && !this.peer.disposed && tl != null) {
            Command command = (Command)this.messageQueue.poll();
            tl.onCommand(command);
        }
        return !this.messageQueue.isEmpty() && !this.peer.disposed && this.peer.transportListener != null;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public int getAsyncQueueDepth() {
        return this.asyncQueueDepth;
    }

    public void setAsyncQueueDepth(int asyncQueueDepth) {
        this.asyncQueueDepth = asyncQueueDepth;
    }

    protected void wakeup() {
        if (this.async && this.messageQueue != null && !this.messageQueue.isEmpty()) {
            if (this.taskRunner == null) {
                this.taskRunner = taskRunnerFactory.createTaskRunner(this, "VMTransport: " + this.toString());
            }
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected synchronized LinkedBlockingQueue getMessageQueue() {
        if (this.messageQueue == null) {
            this.messageQueue = new LinkedBlockingQueue(this.asyncQueueDepth);
        }
        return this.messageQueue;
    }
}

