/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.Service;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ServiceSupport
implements Service {
    private static final Log log = LogFactory.getLog(ServiceSupport.class);
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);

    public static void dispose(Service service) {
        try {
            service.stop();
        }
        catch (Exception e) {
            log.debug("Could not stop service: " + service + ". Reason: " + e, e);
        }
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.doStart();
        }
    }

    public void stop() throws Exception {
        if (this.stopped.compareAndSet(false, true)) {
            this.stopping.set(true);
            ServiceStopper stopper = new ServiceStopper();
            try {
                this.doStop(stopper);
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
            this.stopped.set(true);
            this.started.set(false);
            this.stopping.set(false);
            stopper.throwFirstException();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    protected abstract void doStop(ServiceStopper var1) throws Exception;

    protected abstract void doStart() throws Exception;
}

