/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.config.AdviceEntry;
import org.springframework.aop.config.AdvisorComponentDefinition;
import org.springframework.aop.config.AdvisorEntry;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.aop.config.AspectComponentDefinition;
import org.springframework.aop.config.AspectEntry;
import org.springframework.aop.config.PointcutComponentDefinition;
import org.springframework.aop.config.PointcutEntry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.parsing.ParseState;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ConfigBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ASPECT = "aspect";
    private static final String EXPRESSION = "expression";
    private static final String ID = "id";
    private static final String POINTCUT = "pointcut";
    private static final String ADVICE_BEAN_NAME = "adviceBeanName";
    private static final String ADVISOR = "advisor";
    private static final String ADVICE_REF = "advice-ref";
    private static final String POINTCUT_REF = "pointcut-ref";
    private static final String REF = "ref";
    private static final String BEFORE = "before";
    private static final String DECLARE_PARENTS = "declare-parents";
    private static final String TYPE_PATTERN = "types-matching";
    private static final String DEFAULT_IMPL = "default-impl";
    private static final String IMPLEMENT_INTERFACE = "implement-interface";
    private static final String AFTER = "after";
    private static final String AFTER_RETURNING_ELEMENT = "after-returning";
    private static final String AFTER_THROWING_ELEMENT = "after-throwing";
    private static final String AROUND = "around";
    private static final String PROXY_TARGET_CLASS = "proxy-target-class";
    private static final String RETURNING = "returning";
    private static final String RETURNING_PROPERTY = "returningName";
    private static final String THROWING = "throwing";
    private static final String THROWING_PROPERTY = "throwingName";
    private static final String ARG_NAMES = "arg-names";
    private static final String ARG_NAMES_PROPERTY = "argumentNames";
    private static final String ASPECT_NAME_PROPERTY = "aspectName";
    private static final String DECLARATION_ORDER_PROPERTY = "declarationOrder";
    private static final String ORDER_PROPERTY = "order";
    private static final int METHOD_INDEX = 0;
    private static final int POINTCUT_INDEX = 1;
    private static final int ASPECT_INSTANCE_FACTORY_INDEX = 2;
    private ParseState parseState = new ParseState();
    static /* synthetic */ Class class$org$springframework$aop$support$DefaultBeanFactoryPointcutAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$DeclareParentsAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$config$MethodLocatingFactoryBean;
    static /* synthetic */ Class class$org$springframework$aop$config$SimpleBeanFactoryAwareAspectInstanceFactory;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJPointcutAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAroundAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJExpressionPointcut;

    ConfigBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource(element));
        parserContext.pushContainingComponent(compositeDef);
        this.configureAutoProxyCreator(parserContext, element);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if (POINTCUT.equals(localName)) {
                this.parsePointcut((Element)node, parserContext);
                continue;
            }
            if (ADVISOR.equals(localName)) {
                this.parseAdvisor((Element)node, parserContext);
                continue;
            }
            if (!ASPECT.equals(localName)) continue;
            this.parseAspect((Element)node, parserContext);
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void configureAutoProxyCreator(ParserContext parserContext, Element element) {
        AopNamespaceUtils.registerAspectJAutoProxyCreatorIfNecessary(parserContext, element);
        boolean proxyTargetClass = Boolean.valueOf(element.getAttribute(PROXY_TARGET_CLASS));
        if (proxyTargetClass) {
            AopNamespaceUtils.forceAutoProxyCreatorToUseClassProxying(parserContext.getRegistry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAdvisor(Element advisorElement, ParserContext parserContext) {
        AbstractBeanDefinition advisorDef = this.createAdvisorBeanDefinition(advisorElement, parserContext);
        String id = advisorElement.getAttribute(ID);
        try {
            this.parseState.push(new AdvisorEntry(id));
            String pointcutBeanName = this.parsePointcutProperty(advisorElement, parserContext);
            advisorDef.getPropertyValues().addPropertyValue(POINTCUT, new RuntimeBeanReference(pointcutBeanName));
            String advisorBeanName = id;
            if (StringUtils.hasText(advisorBeanName)) {
                parserContext.getRegistry().registerBeanDefinition(advisorBeanName, advisorDef);
            } else {
                advisorBeanName = parserContext.getReaderContext().registerWithGeneratedName(advisorDef);
            }
            boolean pointcutRef = advisorElement.hasAttribute(POINTCUT_REF);
            if (pointcutBeanName != null) {
                this.fireAdvisorEvent(advisorBeanName, pointcutBeanName, advisorDef, parserContext, pointcutRef);
            }
        }
        finally {
            this.parseState.pop();
        }
    }

    private void fireAdvisorEvent(String advisorBeanName, String pointcutBeanName, AbstractBeanDefinition advisorDef, ParserContext parserContext, boolean pointcutRef) {
        AdvisorComponentDefinition componentDefinition;
        if (pointcutRef) {
            componentDefinition = new AdvisorComponentDefinition(advisorBeanName, advisorDef);
        } else {
            BeanDefinition pointcutDefinition = parserContext.getRegistry().getBeanDefinition(pointcutBeanName);
            componentDefinition = new AdvisorComponentDefinition(advisorBeanName, advisorDef, pointcutDefinition);
        }
        parserContext.registerComponent(componentDefinition);
    }

    private AbstractBeanDefinition createAdvisorBeanDefinition(Element advisorElement, ParserContext parserContext) {
        RootBeanDefinition advisorDefinition = new RootBeanDefinition(class$org$springframework$aop$support$DefaultBeanFactoryPointcutAdvisor == null ? (class$org$springframework$aop$support$DefaultBeanFactoryPointcutAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor")) : class$org$springframework$aop$support$DefaultBeanFactoryPointcutAdvisor);
        advisorDefinition.setSource(parserContext.extractSource(advisorElement));
        if (advisorElement.hasAttribute(ORDER_PROPERTY)) {
            advisorDefinition.getPropertyValues().addPropertyValue(ORDER_PROPERTY, advisorElement.getAttribute(ORDER_PROPERTY));
        }
        advisorDefinition.getPropertyValues().addPropertyValue(ADVICE_BEAN_NAME, new RuntimeBeanNameReference(advisorElement.getAttribute(ADVICE_REF)));
        return advisorDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAspect(Element aspectElement, ParserContext parserContext) {
        String aspectId = aspectElement.getAttribute(ID);
        String aspectName = aspectElement.getAttribute(REF);
        if (!StringUtils.hasText(aspectName)) {
            parserContext.getReaderContext().error("<aspect> tag needs aspect bean reference via 'ref' attribute.", (Object)aspectElement, this.parseState.snapshot());
            return;
        }
        try {
            this.parseState.push(new AspectEntry(aspectId, aspectName));
            ArrayList<AbstractBeanDefinition> beanDefinitions = new ArrayList<AbstractBeanDefinition>();
            ArrayList<RuntimeBeanReference> beanReferences = new ArrayList<RuntimeBeanReference>();
            beanReferences.add(new RuntimeBeanReference(aspectName));
            List declareParents = DomUtils.getChildElementsByTagName(aspectElement, DECLARE_PARENTS);
            for (int i = 0; i < declareParents.size(); ++i) {
                Element declareParentsElement = (Element)declareParents.get(i);
                beanDefinitions.add(this.parseDeclareParents(declareParentsElement, parserContext));
            }
            NodeList nodeList = aspectElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!this.isAdviceNode(node)) continue;
                AbstractBeanDefinition advisorDefinition = this.parseAdvice(aspectName, i, aspectElement, (Element)node, parserContext, beanReferences);
                beanDefinitions.add(advisorDefinition);
            }
            AspectComponentDefinition aspectComponentDefinition = this.createAspectComponentDefinition(aspectElement, aspectId, beanDefinitions, beanReferences, parserContext);
            parserContext.pushContainingComponent(aspectComponentDefinition);
            List pointcuts = DomUtils.getChildElementsByTagName(aspectElement, POINTCUT);
            for (int i = 0; i < pointcuts.size(); ++i) {
                Element pointcutElement = (Element)pointcuts.get(i);
                this.parsePointcut(pointcutElement, parserContext);
            }
            parserContext.popAndRegisterContainingComponent();
        }
        finally {
            this.parseState.pop();
        }
    }

    private AspectComponentDefinition createAspectComponentDefinition(Element aspectElement, String aspectId, List beanDefs, List beanRefs, ParserContext parserContext) {
        BeanDefinition[] beanDefArray = beanDefs.toArray(new BeanDefinition[beanDefs.size()]);
        BeanReference[] beanRefArray = beanRefs.toArray(new BeanReference[beanRefs.size()]);
        Object source = parserContext.extractSource(aspectElement);
        return new AspectComponentDefinition(aspectId, beanDefArray, beanRefArray, source);
    }

    private boolean isAdviceNode(Node aNode) {
        if (!(aNode instanceof Element)) {
            return false;
        }
        String name = aNode.getLocalName();
        return BEFORE.equals(name) || AFTER.equals(name) || AFTER_RETURNING_ELEMENT.equals(name) || AFTER_THROWING_ELEMENT.equals(name) || AROUND.equals(name);
    }

    private AbstractBeanDefinition parseDeclareParents(Element declareParentsElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(class$org$springframework$aop$aspectj$DeclareParentsAdvisor == null ? (class$org$springframework$aop$aspectj$DeclareParentsAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.DeclareParentsAdvisor")) : class$org$springframework$aop$aspectj$DeclareParentsAdvisor);
        builder.addConstructorArg(declareParentsElement.getAttribute(IMPLEMENT_INTERFACE));
        builder.addConstructorArg(declareParentsElement.getAttribute(TYPE_PATTERN));
        builder.addConstructorArg(declareParentsElement.getAttribute(DEFAULT_IMPL));
        builder.setSource(parserContext.extractSource(declareParentsElement));
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        parserContext.getReaderContext().registerWithGeneratedName(definition);
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBeanDefinition parseAdvice(String aspectName, int order, Element aspectElement, Element adviceElement, ParserContext parserContext, List beanReferences) {
        try {
            this.parseState.push(new AdviceEntry(adviceElement.getLocalName()));
            RootBeanDefinition methodDefinition = new RootBeanDefinition(class$org$springframework$aop$config$MethodLocatingFactoryBean == null ? (class$org$springframework$aop$config$MethodLocatingFactoryBean = ConfigBeanDefinitionParser.class$("org.springframework.aop.config.MethodLocatingFactoryBean")) : class$org$springframework$aop$config$MethodLocatingFactoryBean);
            methodDefinition.getPropertyValues().addPropertyValue("targetBeanName", aspectName);
            methodDefinition.getPropertyValues().addPropertyValue("methodName", adviceElement.getAttribute("method"));
            methodDefinition.setSynthetic(true);
            RootBeanDefinition aspectFactoryDef = new RootBeanDefinition(class$org$springframework$aop$config$SimpleBeanFactoryAwareAspectInstanceFactory == null ? (class$org$springframework$aop$config$SimpleBeanFactoryAwareAspectInstanceFactory = ConfigBeanDefinitionParser.class$("org.springframework.aop.config.SimpleBeanFactoryAwareAspectInstanceFactory")) : class$org$springframework$aop$config$SimpleBeanFactoryAwareAspectInstanceFactory);
            aspectFactoryDef.getPropertyValues().addPropertyValue("aspectBeanName", aspectName);
            aspectFactoryDef.setSynthetic(true);
            AbstractBeanDefinition adviceDef = this.createAdviceDefinition(adviceElement, parserContext, aspectName, order, methodDefinition, aspectFactoryDef, beanReferences);
            RootBeanDefinition advisorDefinition = new RootBeanDefinition(class$org$springframework$aop$aspectj$AspectJPointcutAdvisor == null ? (class$org$springframework$aop$aspectj$AspectJPointcutAdvisor = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJPointcutAdvisor")) : class$org$springframework$aop$aspectj$AspectJPointcutAdvisor);
            advisorDefinition.setSource(parserContext.extractSource(adviceElement));
            advisorDefinition.getConstructorArgumentValues().addGenericArgumentValue(adviceDef);
            if (aspectElement.hasAttribute(ORDER_PROPERTY)) {
                advisorDefinition.getPropertyValues().addPropertyValue(ORDER_PROPERTY, aspectElement.getAttribute(ORDER_PROPERTY));
            }
            parserContext.getReaderContext().registerWithGeneratedName(advisorDefinition);
            RootBeanDefinition rootBeanDefinition = advisorDefinition;
            return rootBeanDefinition;
        }
        finally {
            this.parseState.pop();
        }
    }

    private AbstractBeanDefinition createAdviceDefinition(Element adviceElement, ParserContext parserContext, String aspectName, int order, RootBeanDefinition methodDef, RootBeanDefinition aspectFactoryDef, List beanReferences) {
        String pointcutBeanName = this.parsePointcutProperty(adviceElement, parserContext);
        RuntimeBeanReference pointcutRef = new RuntimeBeanReference(pointcutBeanName);
        beanReferences.add(pointcutRef);
        RootBeanDefinition adviceDefinition = new RootBeanDefinition(this.getAdviceClass(adviceElement));
        adviceDefinition.setSource(parserContext.extractSource(adviceElement));
        adviceDefinition.getPropertyValues().addPropertyValue(ASPECT_NAME_PROPERTY, aspectName);
        adviceDefinition.getPropertyValues().addPropertyValue(DECLARATION_ORDER_PROPERTY, new Integer(order));
        if (adviceElement.hasAttribute(RETURNING)) {
            adviceDefinition.getPropertyValues().addPropertyValue(RETURNING_PROPERTY, adviceElement.getAttribute(RETURNING));
        }
        if (adviceElement.hasAttribute(THROWING)) {
            adviceDefinition.getPropertyValues().addPropertyValue(THROWING_PROPERTY, adviceElement.getAttribute(THROWING));
        }
        if (adviceElement.hasAttribute(ARG_NAMES)) {
            adviceDefinition.getPropertyValues().addPropertyValue(ARG_NAMES_PROPERTY, adviceElement.getAttribute(ARG_NAMES));
        }
        ConstructorArgumentValues cav = adviceDefinition.getConstructorArgumentValues();
        cav.addIndexedArgumentValue(0, methodDef);
        cav.addIndexedArgumentValue(1, pointcutRef);
        cav.addIndexedArgumentValue(2, aspectFactoryDef);
        return adviceDefinition;
    }

    private Class getAdviceClass(Element adviceElement) {
        String elementName = adviceElement.getLocalName();
        if (BEFORE.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice == null ? (class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJMethodBeforeAdvice")) : class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
        }
        if (AFTER.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterAdvice;
        }
        if (AFTER_RETURNING_ELEMENT.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterReturningAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
        }
        if (AFTER_THROWING_ELEMENT.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAfterThrowingAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
        }
        if (AROUND.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAroundAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAroundAdvice = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJAroundAdvice")) : class$org$springframework$aop$aspectj$AspectJAroundAdvice;
        }
        throw new IllegalArgumentException("Unknown advice kind [" + elementName + "].");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBeanDefinition parsePointcut(Element pointcutElement, ParserContext parserContext) {
        String id = pointcutElement.getAttribute(ID);
        String expression = pointcutElement.getAttribute(EXPRESSION);
        AbstractBeanDefinition pointcutDefinition = null;
        try {
            this.parseState.push(new PointcutEntry(id));
            pointcutDefinition = this.createPointcutDefinition(expression);
            pointcutDefinition.setSource(parserContext.extractSource(pointcutElement));
            if (StringUtils.hasText(id)) {
                parserContext.getRegistry().registerBeanDefinition(id, pointcutDefinition);
            } else {
                parserContext.getReaderContext().registerWithGeneratedName(pointcutDefinition);
            }
            parserContext.registerComponent(new PointcutComponentDefinition(id, pointcutDefinition, expression));
        }
        finally {
            this.parseState.pop();
        }
        return pointcutDefinition;
    }

    private String parsePointcutProperty(Element element, ParserContext parserContext) {
        if (element.hasAttribute(POINTCUT) && element.hasAttribute(POINTCUT_REF)) {
            parserContext.getReaderContext().error("Cannot define both 'pointcut' and 'pointcut-ref' on <advisor> tag.", (Object)element, this.parseState.snapshot());
            return null;
        }
        if (element.hasAttribute(POINTCUT)) {
            Attr pointcutAttr = element.getAttributeNode(POINTCUT);
            AbstractBeanDefinition pointcutDefinition = this.createPointcutDefinition(pointcutAttr.getValue());
            pointcutDefinition.setSource(parserContext.extractSource(element));
            return parserContext.getReaderContext().registerWithGeneratedName(pointcutDefinition);
        }
        if (element.hasAttribute(POINTCUT_REF)) {
            return element.getAttribute(POINTCUT_REF);
        }
        parserContext.getReaderContext().error("Must define one of 'pointcut' or 'pointcut-ref' on <advisor> tag.", (Object)element, this.parseState.snapshot());
        return null;
    }

    protected AbstractBeanDefinition createPointcutDefinition(String expression) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(class$org$springframework$aop$aspectj$AspectJExpressionPointcut == null ? (class$org$springframework$aop$aspectj$AspectJExpressionPointcut = ConfigBeanDefinitionParser.class$("org.springframework.aop.aspectj.AspectJExpressionPointcut")) : class$org$springframework$aop$aspectj$AspectJExpressionPointcut);
        beanDefinition.setSingleton(false);
        beanDefinition.setSynthetic(true);
        beanDefinition.getPropertyValues().addPropertyValue(EXPRESSION, expression);
        return beanDefinition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

