/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.GeneratorStrategy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.transform.impl.UndeclaredThrowableStrategy;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

final class Cglib2AopProxy
implements AopProxy,
Serializable {
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    private static final int DISPATCH_TARGET = 3;
    private static final int DISPATCH_ADVISED = 4;
    private static final int INVOKE_EQUALS = 5;
    private static final int INVOKE_HASHCODE = 6;
    protected static final Log logger = LogFactory.getLog(class$org$springframework$aop$framework$Cglib2AopProxy == null ? (class$org$springframework$aop$framework$Cglib2AopProxy = Cglib2AopProxy.class$("org.springframework.aop.framework.Cglib2AopProxy")) : class$org$springframework$aop$framework$Cglib2AopProxy);
    private static final Set validatedClasses = new HashSet();
    protected final AdvisedSupport advised;
    private Object[] constructorArgs;
    private Class[] constructorArgTypes;
    private final transient AdvisedDispatcher advisedDispatcher;
    private transient Map fixedInterceptorMap;
    private transient int fixedInterceptorOffset;
    static /* synthetic */ Class class$org$springframework$aop$framework$Cglib2AopProxy;
    static /* synthetic */ Class class$java$lang$reflect$UndeclaredThrowableException;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$springframework$aop$framework$Advised;

    public Cglib2AopProxy(AdvisedSupport config) throws AopConfigException {
        Assert.notNull(config, "AdvisedSupport must not be null");
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("No advisors and no TargetSource specified");
        }
        this.advised = config;
        this.advisedDispatcher = new AdvisedDispatcher(this.advised);
    }

    public void setConstructorArguments(Object[] constructorArgs, Class[] constructorArgTypes) {
        if (constructorArgs == null || constructorArgTypes == null) {
            throw new IllegalArgumentException("Both 'constructorArgs' and 'constructorArgTypes' need to be specified");
        }
        if (constructorArgs.length != constructorArgTypes.length) {
            throw new IllegalArgumentException("Number of 'constructorArgs' (" + constructorArgs.length + ") must match number of 'constructorArgTypes' (" + constructorArgTypes.length + ")");
        }
        this.constructorArgs = constructorArgs;
        this.constructorArgTypes = constructorArgTypes;
    }

    public Object getProxy() {
        return this.getProxy(null);
    }

    public Object getProxy(ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating CGLIB2 proxy: target source is " + this.advised.getTargetSource());
        }
        Enhancer enhancer = this.createEnhancer();
        try {
            Class rootClass;
            if (classLoader != null) {
                enhancer.setClassLoader(classLoader);
            }
            Assert.state((rootClass = this.advised.getTargetClass()) != null, "Target class must be available for creating a CGLIB proxy");
            Class proxySuperClass = rootClass;
            if (AopUtils.isCglibProxyClass(rootClass)) {
                proxySuperClass = rootClass.getSuperclass();
                Class<?>[] additionalInterfaces = rootClass.getInterfaces();
                for (int i = 0; i < additionalInterfaces.length; ++i) {
                    Class<?> additionalInterface = additionalInterfaces[i];
                    this.advised.addInterface(additionalInterface);
                }
            }
            this.validateClassIfNecessary(proxySuperClass);
            enhancer.setSuperclass(proxySuperClass);
            enhancer.setStrategy((GeneratorStrategy)new UndeclaredThrowableStrategy(class$java$lang$reflect$UndeclaredThrowableException == null ? (class$java$lang$reflect$UndeclaredThrowableException = Cglib2AopProxy.class$("java.lang.reflect.UndeclaredThrowableException")) : class$java$lang$reflect$UndeclaredThrowableException));
            enhancer.setInterfaces(AopProxyUtils.completeProxiedInterfaces(this.advised));
            enhancer.setInterceptDuringConstruction(false);
            Callback[] callbacks = this.getCallbacks(rootClass);
            enhancer.setCallbacks(callbacks);
            enhancer.setCallbackFilter((CallbackFilter)new ProxyCallbackFilter(this.advised, this.fixedInterceptorMap, this.fixedInterceptorOffset));
            Class[] types = new Class[callbacks.length];
            for (int x = 0; x < types.length; ++x) {
                types[x] = callbacks[x].getClass();
            }
            enhancer.setCallbackTypes(types);
            Object proxy = this.constructorArgs != null ? enhancer.create(this.constructorArgTypes, this.constructorArgs) : enhancer.create();
            return proxy;
        }
        catch (CodeGenerationException ex) {
            throw new AopConfigException("Couldn't generate CGLIB subclass of class [" + this.advised.getTargetClass() + "]: " + "Common causes of this problem include using a final class or a non-visible class", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new AopConfigException("Couldn't generate CGLIB subclass of class [" + this.advised.getTargetClass() + "]: " + "Common causes of this problem include using a final class or a non-visible class", ex);
        }
        catch (Exception ex) {
            throw new AopConfigException("Unexpected AOP exception", ex);
        }
    }

    protected Enhancer createEnhancer() {
        return new Enhancer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateClassIfNecessary(Class proxySuperClass) {
        if (logger.isWarnEnabled()) {
            Set set = validatedClasses;
            synchronized (set) {
                if (!validatedClasses.contains(proxySuperClass)) {
                    this.doValidateClass(proxySuperClass);
                    validatedClasses.add(proxySuperClass);
                }
            }
        }
    }

    private void doValidateClass(Class proxySuperClass) {
        Method[] methods = proxySuperClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method;
            if ((class$java$lang$Object == null ? Cglib2AopProxy.class$("java.lang.Object") : class$java$lang$Object).equals((method = methods[i]).getDeclaringClass()) || !Modifier.isFinal(method.getModifiers())) continue;
            logger.warn("Unable to proxy method [" + method + "] because it is final: " + "All calls to this method via a proxy will be routed directly to the proxy.");
        }
    }

    private Callback[] getCallbacks(Class rootClass) throws Exception {
        Callback[] callbacks;
        boolean exposeProxy = this.advised.isExposeProxy();
        boolean isFrozen = this.advised.isFrozen();
        boolean isStatic = this.advised.getTargetSource().isStatic();
        DynamicAdvisedInterceptor aopInterceptor = new DynamicAdvisedInterceptor(this.advised);
        MethodInterceptor targetInterceptor = null;
        targetInterceptor = exposeProxy ? (isStatic ? new StaticUnadvisedExposedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedExposedInterceptor(this.advised)) : (isStatic ? new StaticUnadvisedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedInterceptor(this.advised));
        Serializable targetDispatcher = isStatic ? new StaticDispatcher(this.advised.getTargetSource().getTarget()) : new SerializableNoOp();
        Callback[] mainCallbacks = new Callback[]{aopInterceptor, targetInterceptor, new SerializableNoOp(), targetDispatcher, this.advisedDispatcher, new EqualsInterceptor(this.advised), new HashCodeInterceptor(this.advised)};
        if (isStatic && isFrozen) {
            int x;
            Method[] methods = rootClass.getMethods();
            Callback[] fixedCallbacks = new Callback[methods.length];
            this.fixedInterceptorMap = new HashMap();
            for (x = 0; x < methods.length; ++x) {
                List chain = this.advised.getInterceptorsAndDynamicInterceptionAdvice(methods[x], rootClass);
                fixedCallbacks[x] = new FixedChainStaticTargetInterceptor(chain, this.advised.getTargetSource().getTarget(), this.advised.getTargetClass());
                this.fixedInterceptorMap.put(methods[x].toString(), new Integer(x));
            }
            callbacks = new Callback[mainCallbacks.length + fixedCallbacks.length];
            for (x = 0; x < mainCallbacks.length; ++x) {
                callbacks[x] = mainCallbacks[x];
            }
            for (x = 0; x < fixedCallbacks.length; ++x) {
                callbacks[x + mainCallbacks.length] = fixedCallbacks[x];
            }
            this.fixedInterceptorOffset = mainCallbacks.length;
        } else {
            callbacks = mainCallbacks;
        }
        return callbacks;
    }

    private static Object massageReturnTypeIfNecessary(Object proxy, Object target, Object retVal) {
        if (retVal != null && retVal == target) {
            retVal = proxy;
        }
        return retVal;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Cglib2AopProxy && AopProxyUtils.equalsInProxy(this.advised, ((Cglib2AopProxy)other).advised);
    }

    public int hashCode() {
        return (class$org$springframework$aop$framework$Cglib2AopProxy == null ? (class$org$springframework$aop$framework$Cglib2AopProxy = Cglib2AopProxy.class$("org.springframework.aop.framework.Cglib2AopProxy")) : class$org$springframework$aop$framework$Cglib2AopProxy).hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ProxyCallbackFilter
    implements CallbackFilter {
        private final AdvisedSupport advised;
        private final Map fixedInterceptorMap;
        private final int fixedInterceptorOffset;

        public ProxyCallbackFilter(AdvisedSupport advised, Map fixedInterceptorMap, int fixedInterceptorOffset) {
            this.advised = advised;
            this.fixedInterceptorMap = fixedInterceptorMap;
            this.fixedInterceptorOffset = fixedInterceptorOffset;
        }

        public int accept(Method method) {
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = Cglib2AopProxy.class$("java.lang.Object")) : class$java$lang$Object) && method.getName().equals("finalize")) {
                logger.debug("Found finalize() method - using NO_OVERRIDE");
                return 2;
            }
            if (!this.advised.opaque && method.getDeclaringClass().isInterface() && method.getDeclaringClass().isAssignableFrom(class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = Cglib2AopProxy.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method is declared on Advised interface: " + method);
                }
                return 4;
            }
            if (AopUtils.isEqualsMethod(method)) {
                logger.debug("Found 'equals' method: " + method);
                return 5;
            }
            if (AopUtils.isHashCodeMethod(method)) {
                logger.debug("Found 'hashCode' method: " + method);
                return 6;
            }
            Class targetClass = this.advised.getTargetClass();
            List chain = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass);
            boolean haveAdvice = !chain.isEmpty();
            boolean exposeProxy = this.advised.isExposeProxy();
            boolean isStatic = this.advised.getTargetSource().isStatic();
            boolean isFrozen = this.advised.isFrozen();
            if (haveAdvice || !isFrozen) {
                if (exposeProxy) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Must expose proxy on advised method: " + method);
                    }
                    return 0;
                }
                String key = method.toString();
                if (isStatic && isFrozen && this.fixedInterceptorMap.containsKey(key)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Method has advice and optimisations are enabled: " + method);
                    }
                    int index = (Integer)this.fixedInterceptorMap.get(key);
                    return index + this.fixedInterceptorOffset;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to apply any optimisations to advised method: " + method);
                }
                return 0;
            }
            if (exposeProxy || !isStatic) {
                return 1;
            }
            Class<?> returnType = method.getReturnType();
            if (targetClass == returnType) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method " + method + "has return type same as target type (may return this) - using INVOKE_TARGET");
                }
                return 1;
            }
            if (returnType.isPrimitive() || !returnType.isAssignableFrom(targetClass)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method " + method + " has return type that ensures this cannot be returned- using DISPATCH_TARGET");
                }
                return 3;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Method " + method + "has return type that is assignable from the target type (may return this) - " + "using INVOKE_TARGET");
            }
            return 1;
        }

        public boolean equals(Object other) {
            Advisor[] thatAdvisors;
            if (other == this) {
                return true;
            }
            if (!(other instanceof ProxyCallbackFilter)) {
                return false;
            }
            ProxyCallbackFilter otherCallbackFilter = (ProxyCallbackFilter)other;
            if (this.advised.isFrozen() != otherCallbackFilter.advised.isFrozen()) {
                return false;
            }
            if (this.advised.isExposeProxy() != otherCallbackFilter.advised.isExposeProxy()) {
                return false;
            }
            if (this.advised.getTargetSource().isStatic() != otherCallbackFilter.advised.getTargetSource().isStatic()) {
                return false;
            }
            if (!AopProxyUtils.equalsProxiedInterfaces(this.advised, otherCallbackFilter.advised)) {
                return false;
            }
            Advisor[] thisAdvisors = this.advised.getAdvisors();
            if (thisAdvisors.length != (thatAdvisors = otherCallbackFilter.advised.getAdvisors()).length) {
                return false;
            }
            for (int i = 0; i < thisAdvisors.length; ++i) {
                Advisor thisAdvisor = thisAdvisors[i];
                Advisor thatAdvisor = thatAdvisors[i];
                if (!this.equalsAdviceClasses(thisAdvisor, thatAdvisor)) {
                    return false;
                }
                if (this.equalsPointcuts(thisAdvisor, thatAdvisor)) continue;
                return false;
            }
            return true;
        }

        private boolean equalsAdviceClasses(Advisor a, Advisor b) {
            Advice aa = a.getAdvice();
            Advice ba = b.getAdvice();
            if (aa == null || ba == null) {
                return aa == ba;
            }
            return aa.getClass().equals(ba.getClass());
        }

        private boolean equalsPointcuts(Advisor a, Advisor b) {
            return a instanceof PointcutAdvisor && b instanceof PointcutAdvisor && ObjectUtils.nullSafeEquals(((PointcutAdvisor)a).getPointcut(), ((PointcutAdvisor)b).getPointcut());
        }

        public int hashCode() {
            int hashCode = 0;
            Advisor[] advisors = this.advised.getAdvisors();
            for (int i = 0; i < advisors.length; ++i) {
                Advice advice = advisors[i].getAdvice();
                if (advice == null) continue;
                hashCode = 13 * hashCode + advice.getClass().hashCode();
            }
            hashCode = 13 * hashCode + (this.advised.isFrozen() ? 1 : 0);
            hashCode = 13 * hashCode + (this.advised.isExposeProxy() ? 1 : 0);
            hashCode = 13 * hashCode + (this.advised.isOptimize() ? 1 : 0);
            hashCode = 13 * hashCode + (this.advised.isOpaque() ? 1 : 0);
            return hashCode;
        }
    }

    private static class CglibMethodInvocation
    extends ReflectiveMethodInvocation {
        private final MethodProxy methodProxy;
        private boolean protectedMethod;

        public CglibMethodInvocation(Object proxy, Object target, Method method, Object[] arguments, Class targetClass, List interceptorsAndDynamicMethodMatchers, MethodProxy methodProxy) {
            super(proxy, target, method, arguments, targetClass, interceptorsAndDynamicMethodMatchers);
            this.methodProxy = methodProxy;
            this.protectedMethod = Modifier.isProtected(method.getModifiers());
        }

        protected Object invokeJoinpoint() throws Throwable {
            if (this.protectedMethod) {
                return super.invokeJoinpoint();
            }
            return this.methodProxy.invoke(this.target, this.arguments);
        }
    }

    private static class DynamicAdvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private AdvisedSupport advised;

        public DynamicAdvisedInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            boolean setProxyContext;
            Object oldProxy;
            block9: {
                CglibMethodInvocation invocation = null;
                oldProxy = null;
                setProxyContext = false;
                Class<?> targetClass = null;
                Object target = null;
                try {
                    List chain;
                    Object retVal = null;
                    if (this.advised.exposeProxy) {
                        oldProxy = AopContext.setCurrentProxy(proxy);
                        setProxyContext = true;
                    }
                    if ((target = this.getTarget()) != null) {
                        targetClass = target.getClass();
                    }
                    if ((chain = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass)).isEmpty() && Modifier.isPublic(method.getModifiers())) {
                        retVal = methodProxy.invoke(target, args);
                    } else {
                        invocation = new CglibMethodInvocation(proxy, target, method, args, targetClass, chain, methodProxy);
                        retVal = invocation.proceed();
                    }
                    object = retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, retVal);
                    if (target == null) break block9;
                }
                catch (Throwable throwable) {
                    if (target != null) {
                        this.releaseTarget(target);
                    }
                    if (setProxyContext) {
                        AopContext.setCurrentProxy(oldProxy);
                    }
                    throw throwable;
                }
                this.releaseTarget(target);
            }
            if (setProxyContext) {
                AopContext.setCurrentProxy(oldProxy);
            }
            return object;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DynamicAdvisedInterceptor && this.advised.equals(((DynamicAdvisedInterceptor)other).advised);
        }

        public int hashCode() {
            return this.advised.hashCode();
        }

        protected Object getTarget() throws Exception {
            return this.advised.getTargetSource().getTarget();
        }

        protected void releaseTarget(Object target) throws Exception {
            this.advised.getTargetSource().releaseTarget(target);
        }
    }

    private static class FixedChainStaticTargetInterceptor
    implements MethodInterceptor,
    Serializable {
        private final List adviceChain;
        private final Object target;
        private final Class targetClass;

        public FixedChainStaticTargetInterceptor(List adviceChain, Object target, Class targetClass) {
            this.adviceChain = adviceChain;
            this.target = target;
            this.targetClass = targetClass;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = null;
            CglibMethodInvocation invocation = new CglibMethodInvocation(proxy, this.target, method, args, this.targetClass, this.adviceChain, methodProxy);
            retVal = invocation.proceed();
            retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
            return retVal;
        }
    }

    private static class HashCodeInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public HashCodeInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            return new Integer((class$org$springframework$aop$framework$Cglib2AopProxy == null ? (class$org$springframework$aop$framework$Cglib2AopProxy = Cglib2AopProxy.class$("org.springframework.aop.framework.Cglib2AopProxy")) : class$org$springframework$aop$framework$Cglib2AopProxy).hashCode() * 13 + this.advised.getTargetSource().hashCode());
        }
    }

    private static class EqualsInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public EqualsInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            Callback callback;
            Object other = args[0];
            if (proxy == other) {
                return Boolean.TRUE;
            }
            AdvisedSupport otherAdvised = null;
            if (other instanceof Factory) {
                callback = ((Factory)other).getCallback(5);
                if (!(callback instanceof EqualsInterceptor)) {
                    return Boolean.FALSE;
                }
            } else {
                return Boolean.FALSE;
            }
            otherAdvised = ((EqualsInterceptor)callback).advised;
            return AopProxyUtils.equalsInProxy(this.advised, otherAdvised) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class AdvisedDispatcher
    implements Dispatcher,
    Serializable {
        private final AdvisedSupport advised;

        public AdvisedDispatcher(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object loadObject() throws Exception {
            return this.advised;
        }
    }

    private static class StaticDispatcher
    implements Dispatcher,
    Serializable {
        private Object target;

        public StaticDispatcher(Object target) {
            this.target = target;
        }

        public Object loadObject() {
            return this.target;
        }
    }

    private static class DynamicUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public DynamicUnadvisedExposedInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            Object target = this.advised.getTargetSource().getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = methodProxy.invoke(target, args);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
                this.advised.getTargetSource().releaseTarget(target);
            }
        }
    }

    private static class DynamicUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public DynamicUnadvisedInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object target = this.advised.getTargetSource().getTarget();
            try {
                Object retVal = methodProxy.invoke(target, args);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, retVal);
                return object;
            }
            finally {
                this.advised.getTargetSource().releaseTarget(target);
            }
        }
    }

    private static class StaticUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedExposedInterceptor(Object target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = methodProxy.invoke(this.target, args);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
            }
        }
    }

    private static class StaticUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedInterceptor(Object target) {
            this.target = target;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = methodProxy.invoke(this.target, args);
            return Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, retVal);
        }
    }

    public static class SerializableNoOp
    implements NoOp,
    Serializable {
    }
}

