/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.springframework.aop.target.AbstractPoolingTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.core.Constants;

public class CommonsPoolTargetSource
extends AbstractPoolingTargetSource
implements PoolableObjectFactory {
    private static final Constants constants = new Constants(class$org$apache$commons$pool$impl$GenericObjectPool == null ? (class$org$apache$commons$pool$impl$GenericObjectPool = CommonsPoolTargetSource.class$("org.apache.commons.pool.impl.GenericObjectPool")) : class$org$apache$commons$pool$impl$GenericObjectPool);
    private int maxIdle = 8;
    private int minIdle = 0;
    private long maxWait = -1L;
    private long timeBetweenEvictionRunsMillis = -1L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private byte whenExhaustedAction = 1;
    private ObjectPool pool;
    static /* synthetic */ Class class$org$apache$commons$pool$impl$GenericObjectPool;

    public CommonsPoolTargetSource() {
        this.setMaxSize(8);
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setWhenExhaustedActionName(String whenExhaustedActionName) {
        this.setWhenExhaustedAction(constants.asNumber(whenExhaustedActionName).byteValue());
    }

    public void setWhenExhaustedAction(byte whenExhaustedAction) {
        this.whenExhaustedAction = whenExhaustedAction;
    }

    public byte getWhenExhaustedAction() {
        return this.whenExhaustedAction;
    }

    protected final void createPool() {
        this.logger.debug("Creating Commons object pool");
        this.pool = this.createObjectPool();
    }

    protected ObjectPool createObjectPool() {
        GenericObjectPool gop = new GenericObjectPool(this);
        gop.setMaxActive(this.getMaxSize());
        gop.setMaxIdle(this.getMaxIdle());
        gop.setMinIdle(this.getMinIdle());
        gop.setMaxWait(this.getMaxWait());
        gop.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        gop.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        gop.setWhenExhaustedAction(this.getWhenExhaustedAction());
        return gop;
    }

    public Object getTarget() throws Exception {
        return this.pool.borrowObject();
    }

    public void releaseTarget(Object target) throws Exception {
        this.pool.returnObject(target);
    }

    public int getActiveCount() throws UnsupportedOperationException {
        return this.pool.getNumActive();
    }

    public int getIdleCount() throws UnsupportedOperationException {
        return this.pool.getNumIdle();
    }

    public void destroy() throws Exception {
        this.logger.debug("Closing Commons ObjectPool");
        this.pool.close();
    }

    public Object makeObject() throws BeansException {
        return this.newPrototypeInstance();
    }

    public void destroyObject(Object obj) throws Exception {
        this.destroyPrototypeInstance(obj);
    }

    public boolean validateObject(Object obj) {
        return true;
    }

    public void activateObject(Object obj) {
    }

    public void passivateObject(Object obj) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

