/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;

public abstract class CollectionFactory {
    private static final Log logger = LogFactory.getLog(class$org$springframework$core$CollectionFactory == null ? (class$org$springframework$core$CollectionFactory = CollectionFactory.class$("org.springframework.core.CollectionFactory")) : class$org$springframework$core$CollectionFactory);
    private static final boolean commonsCollections3Available = ClassUtils.isPresent("org.apache.commons.collections.map.LinkedMap", (class$org$springframework$core$CollectionFactory == null ? (class$org$springframework$core$CollectionFactory = CollectionFactory.class$("org.springframework.core.CollectionFactory")) : class$org$springframework$core$CollectionFactory).getClassLoader());
    static /* synthetic */ Class class$org$springframework$core$CollectionFactory;

    public static Set createLinkedSetIfPossible(int initialCapacity) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.trace("Creating [java.util.LinkedHashSet]");
            return Jdk14CollectionFactory.createLinkedHashSet(initialCapacity);
        }
        if (commonsCollections3Available) {
            logger.trace("Creating [org.apache.commons.collections.set.ListOrderedSet]");
            return CommonsCollectionFactory.createListOrderedSet(initialCapacity);
        }
        logger.debug("Falling back to plain [java.util.HashSet] for linked set");
        return new HashSet(initialCapacity);
    }

    public static Map createLinkedMapIfPossible(int initialCapacity) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.trace("Creating [java.util.LinkedHashMap]");
            return Jdk14CollectionFactory.createLinkedHashMap(initialCapacity);
        }
        if (commonsCollections3Available) {
            logger.trace("Creating [org.apache.commons.collections.map.LinkedMap]");
            return CommonsCollectionFactory.createLinkedMap(initialCapacity);
        }
        logger.debug("Falling back to plain[java.util.HashMap] for linked map");
        return new HashMap(initialCapacity);
    }

    public static Map createLinkedCaseInsensitiveMapIfPossible(int initialCapacity) {
        if (commonsCollections3Available) {
            logger.trace("Creating [org.apache.commons.collections.map.ListOrderedMap/CaseInsensitiveMap]");
            return CommonsCollectionFactory.createListOrderedCaseInsensitiveMap(initialCapacity);
        }
        if (JdkVersion.isAtLeastJava14()) {
            logger.debug("Falling back to [java.util.LinkedHashMap] for linked case-insensitive map");
            return Jdk14CollectionFactory.createLinkedHashMap(initialCapacity);
        }
        logger.debug("Falling back to plain [java.util.HashMap] for linked case-insensitive map");
        return new HashMap(initialCapacity);
    }

    public static Map createIdentityMapIfPossible(int initialCapacity) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.trace("Creating [java.util.IdentityHashMap]");
            return Jdk14CollectionFactory.createIdentityHashMap(initialCapacity);
        }
        if (commonsCollections3Available) {
            logger.trace("Creating [org.apache.commons.collections.map.IdentityMap]");
            return CommonsCollectionFactory.createIdentityMap(initialCapacity);
        }
        logger.debug("Falling back to plain [java.util.HashMap] for identity map");
        return new HashMap(initialCapacity);
    }

    public static Collection createApproximateCollection(Object collection, int initialCapacity) {
        if (collection instanceof List) {
            return new ArrayList(initialCapacity);
        }
        if (collection instanceof SortedSet) {
            return new TreeSet(((SortedSet)collection).comparator());
        }
        return CollectionFactory.createLinkedSetIfPossible(initialCapacity);
    }

    public static Map createApproximateMap(Object map, int initialCapacity) {
        if (map instanceof SortedMap) {
            return new TreeMap(((SortedMap)map).comparator());
        }
        return CollectionFactory.createLinkedMapIfPossible(initialCapacity);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static abstract class CommonsCollectionFactory {
        private CommonsCollectionFactory() {
        }

        private static Set createListOrderedSet(int initialCapacity) {
            return ListOrderedSet.decorate(new HashSet(initialCapacity));
        }

        private static Map createLinkedMap(int initialCapacity) {
            return new LinkedMap(initialCapacity == 0 ? 1 : initialCapacity);
        }

        private static Map createListOrderedCaseInsensitiveMap(int initialCapacity) {
            return ListOrderedMap.decorate(new CaseInsensitiveMap(initialCapacity == 0 ? 1 : initialCapacity));
        }

        private static Map createIdentityMap(int initialCapacity) {
            return new IdentityMap(initialCapacity == 0 ? 1 : initialCapacity);
        }
    }

    private static abstract class Jdk14CollectionFactory {
        private Jdk14CollectionFactory() {
        }

        private static Set createLinkedHashSet(int initialCapacity) {
            return new LinkedHashSet(initialCapacity);
        }

        private static Map createLinkedHashMap(int initialCapacity) {
            return new LinkedHashMap(initialCapacity);
        }

        private static Map createIdentityHashMap(int initialCapacity) {
            return new IdentityHashMap(initialCapacity);
        }
    }
}

