/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;

public abstract class AbstractSessionFactory
implements SessionFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$oracle$toplink$sessions$Session;

    public Session createSession() throws TopLinkException {
        this.logger.debug("Creating TopLink client Session");
        return this.createClientSession();
    }

    public Session createManagedClientSession() throws TopLinkException {
        this.logger.debug("Creating managed TopLink client Session");
        return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$oracle$toplink$sessions$Session == null ? (class$oracle$toplink$sessions$Session = AbstractSessionFactory.class$("oracle.toplink.sessions.Session")) : class$oracle$toplink$sessions$Session}, (InvocationHandler)new ManagedClientInvocationHandler(this.createClientSession()));
    }

    public Session createTransactionAwareSession() throws TopLinkException {
        this.logger.debug("Creating transaction-aware TopLink Session");
        return this.createTransactionAwareSession(this);
    }

    public Session createTransactionAwareSession(SessionFactory sessionFactory) throws TopLinkException {
        return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$oracle$toplink$sessions$Session == null ? (class$oracle$toplink$sessions$Session = AbstractSessionFactory.class$("oracle.toplink.sessions.Session")) : class$oracle$toplink$sessions$Session}, (InvocationHandler)new TransactionAwareInvocationHandler(sessionFactory, this.getMasterSession()));
    }

    protected abstract Session getMasterSession();

    protected abstract Session createClientSession() throws TopLinkException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final SessionFactory sessionFactory;
        private final Session target;

        public TransactionAwareInvocationHandler(SessionFactory sessionFactory, Session target) {
            this.sessionFactory = sessionFactory;
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getActiveSession")) {
                try {
                    return SessionFactoryUtils.doGetSession(this.sessionFactory, false);
                }
                catch (IllegalStateException ex) {
                    return this.target;
                }
            }
            if (method.getName().equals("getActiveUnitOfWork")) {
                try {
                    return SessionFactoryUtils.doGetSession(this.sessionFactory, false).getActiveUnitOfWork();
                }
                catch (IllegalStateException ex) {
                    return null;
                }
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class ManagedClientInvocationHandler
    implements InvocationHandler {
        private final Session target;
        private final UnitOfWork uow;

        public ManagedClientInvocationHandler(Session target) {
            this.target = target;
            this.uow = this.target.acquireUnitOfWork();
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getActiveSession")) {
                return this.target;
            }
            if (method.getName().equals("getActiveUnitOfWork")) {
                return this.uow;
            }
            if (method.getName().equals("release")) {
                this.uow.release();
                this.target.release();
            } else {
                if (method.getName().equals("equals")) {
                    return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.hashCode());
                }
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

