/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.util.Assert;

public class ThreadPoolTaskExecutor
implements SchedulingTaskExecutor,
Executor,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Object poolSizeMonitor = new Object();
    private int corePoolSize = 1;
    private int maxPoolSize = Integer.MAX_VALUE;
    private int keepAliveSeconds = 60;
    private int queueCapacity = Integer.MAX_VALUE;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private ThreadPoolExecutor threadPoolExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int corePoolSize) {
        Object object = this.poolSizeMonitor;
        synchronized (object) {
            this.corePoolSize = corePoolSize;
            if (this.threadPoolExecutor != null) {
                this.threadPoolExecutor.setCorePoolSize(corePoolSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCorePoolSize() {
        Object object = this.poolSizeMonitor;
        synchronized (object) {
            return this.corePoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPoolSize(int maxPoolSize) {
        Object object = this.poolSizeMonitor;
        synchronized (object) {
            this.maxPoolSize = maxPoolSize;
            if (this.threadPoolExecutor != null) {
                this.threadPoolExecutor.setMaximumPoolSize(maxPoolSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxPoolSize() {
        Object object = this.poolSizeMonitor;
        synchronized (object) {
            return this.maxPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepAliveSeconds(int keepAliveSeconds) {
        Object object = this.poolSizeMonitor;
        synchronized (object) {
            this.keepAliveSeconds = keepAliveSeconds;
            if (this.threadPoolExecutor != null) {
                this.threadPoolExecutor.setKeepAliveTime(keepAliveSeconds, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeepAliveSeconds() {
        Object object = this.poolSizeMonitor;
        synchronized (object) {
            return this.keepAliveSeconds;
        }
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler != null ? rejectedExecutionHandler : new ThreadPoolExecutor.AbortPolicy();
    }

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void initialize() {
        this.logger.info("Creating ThreadPoolExecutor");
        BlockingQueue queue = this.createQueue(this.queueCapacity);
        this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveSeconds, TimeUnit.SECONDS, queue, this.threadFactory, this.rejectedExecutionHandler);
    }

    protected BlockingQueue createQueue(int queueCapacity) {
        if (queueCapacity > 0) {
            return new LinkedBlockingQueue(queueCapacity);
        }
        return new SynchronousQueue();
    }

    public ThreadPoolExecutor getThreadPoolExecutor() throws IllegalStateException {
        Assert.state(this.threadPoolExecutor != null, "ThreadPoolTaskExecutor not initialized");
        return this.threadPoolExecutor;
    }

    public void execute(Runnable task) {
        ThreadPoolExecutor executor = this.getThreadPoolExecutor();
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public int getPoolSize() {
        return this.getThreadPoolExecutor().getPoolSize();
    }

    public int getActiveCount() {
        return this.getThreadPoolExecutor().getActiveCount();
    }

    public void destroy() {
        this.shutdown();
    }

    public void shutdown() {
        this.logger.info("Shutting down ThreadPoolExecutor");
        this.threadPoolExecutor.shutdown();
    }
}

