/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.jta.UserTransactionAdapter;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SpringJtaSynchronizationAdapter
implements Synchronization {
    protected static final Log logger = LogFactory.getLog(class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter == null ? (class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter = SpringJtaSynchronizationAdapter.class$("org.springframework.transaction.jta.SpringJtaSynchronizationAdapter")) : class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter);
    private final TransactionSynchronization springSynchronization;
    private UserTransaction jtaTransaction;
    private boolean beforeCompletionCalled = false;
    static /* synthetic */ Class class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter;

    public SpringJtaSynchronizationAdapter(TransactionSynchronization springSynchronization) {
        Assert.notNull(springSynchronization, "TransactionSynchronization must not be null");
        this.springSynchronization = springSynchronization;
    }

    public SpringJtaSynchronizationAdapter(TransactionSynchronization springSynchronization, UserTransaction jtaUserTransaction) {
        this(springSynchronization);
        if (jtaUserTransaction != null && !jtaUserTransaction.getClass().getName().startsWith("weblogic.")) {
            this.jtaTransaction = jtaUserTransaction;
        }
    }

    public SpringJtaSynchronizationAdapter(TransactionSynchronization springSynchronization, TransactionManager jtaTransactionManager) {
        this(springSynchronization);
        if (jtaTransactionManager != null && !jtaTransactionManager.getClass().getName().startsWith("weblogic.")) {
            this.jtaTransaction = new UserTransactionAdapter(jtaTransactionManager);
        }
    }

    public void beforeCompletion() {
        try {
            boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            this.springSynchronization.beforeCommit(readOnly);
        }
        catch (RuntimeException ex) {
            this.setRollbackOnlyIfPossible();
            throw ex;
        }
        catch (Error err) {
            this.setRollbackOnlyIfPossible();
            throw err;
        }
        finally {
            this.beforeCompletionCalled = true;
            this.springSynchronization.beforeCompletion();
        }
    }

    private void setRollbackOnlyIfPossible() {
        if (this.jtaTransaction != null) {
            try {
                this.jtaTransaction.setRollbackOnly();
            }
            catch (UnsupportedOperationException ex) {
                logger.debug("JTA transaction handle does not support setRollbackOnly method - relying on JTA provider to mark the transaction as rollback-only based on the exception thrown from beforeCompletion", ex);
            }
            catch (Throwable ex) {
                logger.error("Could not set JTA transaction rollback-only", ex);
            }
        } else {
            logger.debug("No JTA transaction handle available and/or running on WebLogic - relying on JTA provider to mark the transaction as rollback-only based on the exception thrown from beforeCompletion");
        }
    }

    public void afterCompletion(int status) {
        if (!this.beforeCompletionCalled) {
            this.springSynchronization.beforeCompletion();
        }
        switch (status) {
            case 3: {
                this.springSynchronization.afterCompletion(0);
                break;
            }
            case 4: {
                this.springSynchronization.afterCompletion(1);
                break;
            }
            default: {
                this.springSynchronization.afterCompletion(2);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

