/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestContextListener
implements ServletRequestListener {
    private static final String REQUEST_ATTRIBUTES_ATTRIBUTE = (class$org$springframework$web$context$request$RequestContextListener == null ? (class$org$springframework$web$context$request$RequestContextListener = RequestContextListener.class$("org.springframework.web.context.request.RequestContextListener")) : class$org$springframework$web$context$request$RequestContextListener).getName() + ".REQUEST_ATTRIBUTES";
    protected final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$web$context$request$RequestContextListener;

    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (!(requestEvent.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HttpServletRequest: " + requestEvent.getServletRequest());
        }
        HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
        ServletRequestAttributes attributes = new ServletRequestAttributes(request);
        request.setAttribute(REQUEST_ATTRIBUTES_ATTRIBUTE, attributes);
        LocaleContextHolder.setLocale(request.getLocale());
        RequestContextHolder.setRequestAttributes(attributes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound request context to thread: " + request);
        }
    }

    public void requestDestroyed(ServletRequestEvent requestEvent) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)requestEvent.getServletRequest().getAttribute(REQUEST_ATTRIBUTES_ATTRIBUTE);
        ServletRequestAttributes threadAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (threadAttributes != null) {
            if (attributes == null) {
                attributes = threadAttributes;
            }
            RequestContextHolder.setRequestAttributes(null);
            LocaleContextHolder.setLocale(null);
        }
        if (attributes != null) {
            attributes.requestCompleted();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Cleared thread-bound request context: " + requestEvent.getServletRequest());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

