/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.cos;

import com.oreilly.servlet.MultipartRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class CosMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    protected static final Log logger = LogFactory.getLog(class$org$springframework$web$multipart$cos$CosMultipartHttpServletRequest == null ? (class$org$springframework$web$multipart$cos$CosMultipartHttpServletRequest = CosMultipartHttpServletRequest.class$("org.springframework.web.multipart.cos.CosMultipartHttpServletRequest")) : class$org$springframework$web$multipart$cos$CosMultipartHttpServletRequest);
    private final MultipartRequest multipartRequest;
    static /* synthetic */ Class class$org$springframework$web$multipart$cos$CosMultipartHttpServletRequest;

    protected CosMultipartHttpServletRequest(HttpServletRequest request, MultipartRequest multipartRequest) {
        super(request);
        this.multipartRequest = multipartRequest;
        this.setMultipartFiles(this.initFileMap(multipartRequest));
    }

    public MultipartRequest getMultipartRequest() {
        return this.multipartRequest;
    }

    private Map initFileMap(MultipartRequest multipartRequest) {
        HashMap<String, CosMultipartFile> files = new HashMap<String, CosMultipartFile>();
        Enumeration fileNames = multipartRequest.getFileNames();
        while (fileNames.hasMoreElements()) {
            String fileName = (String)fileNames.nextElement();
            files.put(fileName, new CosMultipartFile(fileName));
        }
        return files;
    }

    public Enumeration getParameterNames() {
        return this.multipartRequest.getParameterNames();
    }

    public String getParameter(String name) {
        return this.multipartRequest.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.multipartRequest.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        Enumeration names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            params.put(name, this.getParameterValues(name));
        }
        return Collections.unmodifiableMap(params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CosMultipartFile
    implements MultipartFile {
        private final String name;
        private final File file;
        private final long size;

        public CosMultipartFile(String name) {
            this.name = name;
            this.file = CosMultipartHttpServletRequest.this.multipartRequest.getFile(this.name);
            this.size = this.file != null ? this.file.length() : 0L;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalFilename() {
            String filename = CosMultipartHttpServletRequest.this.multipartRequest.getOriginalFileName(this.name);
            return filename != null ? filename : "";
        }

        public String getContentType() {
            return CosMultipartHttpServletRequest.this.multipartRequest.getContentType(this.name);
        }

        public boolean isEmpty() {
            return this.size == 0L;
        }

        public long getSize() {
            return this.size;
        }

        public byte[] getBytes() throws IOException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has been moved - cannot be read again");
            }
            return this.size > 0L ? FileCopyUtils.copyToByteArray(this.file) : new byte[]{};
        }

        public InputStream getInputStream() throws IOException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has been moved - cannot be read again");
            }
            if (this.size != 0L) {
                return new FileInputStream(this.file);
            }
            return new ByteArrayInputStream(new byte[0]);
        }

        public void transferTo(File dest) throws IOException, IllegalStateException {
            if (this.file != null && !this.file.exists()) {
                throw new IllegalStateException("File has already been moved - cannot be transferred again");
            }
            if (dest.exists() && !dest.delete()) {
                throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
            }
            boolean moved = false;
            if (this.file != null) {
                moved = this.file.renameTo(dest);
                if (!moved) {
                    FileCopyUtils.copy(this.file, dest);
                }
            } else {
                dest.createNewFile();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Multipart file '" + this.getName() + "' with original filename [" + this.getOriginalFilename() + "], stored " + (this.file != null ? "at [" + this.file.getAbsolutePath() + "]" : "in memory") + ": " + (moved ? "moved" : "copied") + " to [" + dest.getAbsolutePath() + "]");
            }
        }
    }
}

